/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.connectors.model;

import de.iip_ecosphere.platform.connectors.model.ModelInputConverter;
import de.iip_ecosphere.platform.connectors.model.ModelOutputConverter;
import java.io.IOException;

public interface ModelAccess {
    public String topInstancesQName();

    public String getQSeparator();

    public String qName(String ... var1);

    public String iqName(String ... var1);

    public Object call(String var1, Object ... var2) throws IOException;

    public Object get(String var1) throws IOException;

    default public Object get(String qName, int lifetime) throws IOException {
        return this.get(qName);
    }

    default public int getInt(String qName) throws IOException {
        Object tmp = this.get(qName);
        if (tmp.getClass() == Integer.class) {
            return (Integer)tmp;
        }
        throw new IOException("Cannot turn " + tmp + "into an int");
    }

    default public float getFloat(String qName) throws IOException {
        Object tmp = this.get(qName);
        if (tmp.getClass() == Float.class) {
            return ((Float)tmp).floatValue();
        }
        throw new IOException("Cannot turn " + tmp + "into a double");
    }

    default public double getDouble(String qName) throws IOException {
        Object tmp = this.get(qName);
        if (tmp.getClass() == Double.class) {
            return (Double)tmp;
        }
        throw new IOException("Cannot turn " + tmp + "into a double");
    }

    default public long getLong(String qName) throws IOException {
        Object tmp = this.get(qName);
        if (tmp.getClass() == Long.class) {
            return (Long)tmp;
        }
        throw new IOException("Cannot turn " + tmp + "into a long");
    }

    default public short getShort(String qName) throws IOException {
        Object tmp = this.get(qName);
        if (tmp.getClass() == Short.class) {
            return (Short)tmp;
        }
        throw new IOException("Cannot turn " + tmp + "into a long");
    }

    default public byte getByte(String qName) throws IOException {
        Object tmp = this.get(qName);
        if (tmp.getClass() == Short.class) {
            return (Byte)tmp;
        }
        throw new IOException("Cannot turn " + tmp + "into a byte");
    }

    default public boolean getBoolean(String qName) throws IOException {
        Object tmp = this.get(qName);
        if (tmp.getClass() == Short.class) {
            return (Boolean)tmp;
        }
        throw new IOException("Cannot turn " + tmp + "into a boolean");
    }

    default public String getString(String qName) throws IOException {
        Object tmp = this.get(qName);
        if (tmp.getClass() == String.class) {
            return (String)tmp;
        }
        throw new IOException("Cannot turn " + tmp + "into a string");
    }

    public void set(String var1, Object var2) throws IOException;

    default public void setInt(String qName, int value) throws IOException {
        this.set(qName, value);
    }

    default public void setLong(String qName, long value) throws IOException {
        this.set(qName, value);
    }

    default public void setByte(String qName, byte value) throws IOException {
        this.set(qName, value);
    }

    default public void setShort(String qName, short value) throws IOException {
        this.set(qName, value);
    }

    default public void setBoolean(String qName, boolean value) throws IOException {
        this.set(qName, value);
    }

    default public void setDouble(String qName, double value) throws IOException {
        this.set(qName, value);
    }

    default public void setFloat(String qName, float value) throws IOException {
        this.set(qName, Float.valueOf(value));
    }

    default public void setString(String qName, String value) throws IOException {
        this.set(qName, value);
    }

    public <T> T getStruct(String var1, Class<T> var2) throws IOException;

    public void setStruct(String var1, Object var2) throws IOException;

    public void registerCustomType(Class<?> var1) throws IOException;

    public void monitor(String ... var1) throws IOException;

    public void monitor(int var1, String ... var2) throws IOException;

    public void monitorModelChanges() throws IOException;

    public void monitorModelChanges(int var1) throws IOException;

    public void setDetailNotifiedItem(boolean var1);

    public void useNotifications(boolean var1);

    default public ModelInputConverter getInputConverter() {
        return ModelInputConverter.INSTANCE;
    }

    default public ModelOutputConverter getOutputConverter() {
        return ModelOutputConverter.INSTANCE;
    }

    public ModelAccess stepInto(String var1) throws IOException;

    public ModelAccess stepOut();
}

