/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.connectors.events;

import de.iip_ecosphere.platform.connectors.events.ConnectorInputHandler;
import de.iip_ecosphere.platform.support.ClassLoaderUtils;
import java.lang.reflect.InvocationTargetException;
import org.slf4j.LoggerFactory;

public class ConnectorEventUtils {
    public static <T> ConnectorInputHandler<T> createInputHandlerInstance(ClassLoader loader, String className, Class<T> type) {
        ConnectorInputHandler result = null;
        try {
            Class<?> handlerClass = loader.loadClass(className);
            Object instance = handlerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            result = (ConnectorInputHandler)instance;
        }
        catch (ClassCastException | ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            String loaders = ClassLoaderUtils.hierarchyToString((ClassLoader)loader);
            LoggerFactory.getLogger(ConnectorEventUtils.class).error("Cannot instantiate input handler of type '" + className + " via " + loaders + "': " + e.getClass().getSimpleName() + " " + e.getMessage() + ". Events of type " + type.getName() + " will not be handled!");
        }
        return result;
    }
}

