/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.connectors;

import de.iip_ecosphere.platform.connectors.AdapterSelector;
import de.iip_ecosphere.platform.connectors.CachingStrategy;
import de.iip_ecosphere.platform.connectors.Connector;
import de.iip_ecosphere.platform.connectors.ConnectorParameter;
import de.iip_ecosphere.platform.connectors.ConnectorRegistry;
import de.iip_ecosphere.platform.connectors.events.ConnectorTriggerQuery;
import de.iip_ecosphere.platform.connectors.model.AbstractModelAccess;
import de.iip_ecosphere.platform.connectors.model.ModelAccess;
import de.iip_ecosphere.platform.connectors.types.ProtocolAdapter;
import de.iip_ecosphere.platform.support.identities.IdentityStore;
import de.iip_ecosphere.platform.transport.connectors.ReceptionCallback;
import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;
import javax.net.ssl.SSLContext;
import org.slf4j.LoggerFactory;

public abstract class AbstractConnector<O, I, CO, CI>
implements Connector<O, I, CO, CI>,
AbstractModelAccess.NotificationChangedListener {
    public static final String DEFAULT_CHANNEL = "";
    private ProtocolAdapter<O, I, CO, CI>[] adapter;
    private AdapterSelector<O, I, CO, CI> selector;
    private ReceptionCallback<CO> callback;
    private Timer timer;
    private TimerTask pollTask;
    private ConnectorParameter params;
    private boolean enablePolling = true;
    private CachingStrategy cachingStrategy;

    @SafeVarargs
    protected AbstractConnector(ProtocolAdapter<O, I, CO, CI> ... adapter) {
        this((AdapterSelector<O, I, CO, CI>)null, adapter);
    }

    @SafeVarargs
    protected AbstractConnector(AdapterSelector<O, I, CO, CI> selector, final ProtocolAdapter<O, I, CO, CI> ... adapter) {
        if (null == adapter || adapter.length == 0) {
            throw new IllegalArgumentException("adapter must be given (not null, not empty)");
        }
        for (int a = 0; a < adapter.length; ++a) {
            if (null != adapter[a]) continue;
            throw new IllegalArgumentException("adapter must be given (not null, not empty)");
        }
        this.adapter = adapter;
        this.selector = selector;
        if (null == this.selector) {
            this.selector = new AdapterSelector<O, I, CO, CI>(){

                @Override
                public ProtocolAdapter<O, I, CO, CI> selectSouthOutput(String channel, O data) {
                    return adapter[0];
                }

                @Override
                public ProtocolAdapter<O, I, CO, CI> selectNorthInput(CI data) {
                    return adapter[0];
                }

                @Override
                public void init(AdapterSelector.AdapterProvider<O, I, CO, CI> provider) {
                }
            };
        }
        this.initSelector(this.selector);
        this.cachingStrategy = CachingStrategy.createInstance(this.getInitCachingStrategyCls());
    }

    protected void initSelector(AdapterSelector<O, I, CO, CI> selector) {
        selector.init(new BasicAdapterProvider());
    }

    public static boolean useTls(ConnectorParameter params) {
        return null != params.getKeystoreKey();
    }

    protected SSLContext createTlsContext(ConnectorParameter params) throws IOException {
        return IdentityStore.getInstance().createTlsContext(params.getKeystoreKey(), params.getKeyAlias(), new String[0]);
    }

    protected void configureModelAccess(ModelAccess access) {
        for (int a = 0; a < this.adapter.length; ++a) {
            this.adapter[a].setModelAccess(access);
        }
    }

    protected AdapterSelector<O, I, CO, CI> getSelector() {
        return this.selector;
    }

    @Override
    public void connect(ConnectorParameter params) throws IOException {
        this.params = params;
        if (null != params) {
            this.getCachingStrategy().setCacheMode(params.getCacheMode());
        }
        this.connectImpl(params);
        this.initializeModelAccess();
        ConnectorRegistry.registerConnector(this);
    }

    protected abstract void connectImpl(ConnectorParameter var1) throws IOException;

    protected ConnectorParameter getConnectorParameter() {
        return this.params;
    }

    protected void installPollTask() {
        int pollingPeriod = this.params.getNotificationInterval();
        if (null == this.timer && pollingPeriod > 0) {
            this.timer = new Timer();
            this.pollTask = new TimerTask(){

                @Override
                public void run() {
                    if (AbstractConnector.this.enablePolling) {
                        AbstractConnector.this.doPolling();
                    }
                }
            };
            this.timer.scheduleAtFixedRate(this.pollTask, 0L, (long)pollingPeriod);
        }
    }

    @Override
    public void enablePolling(boolean enablePolling) {
        this.enablePolling = enablePolling;
    }

    protected void doPolling() {
        try {
            O data = this.read();
            if (null != data) {
                this.received(DEFAULT_CHANNEL, data);
            }
        }
        catch (IOException e) {
            this.error("While polling. Data discarded.", e);
        }
    }

    protected boolean isPolling() {
        return null != this.pollTask;
    }

    protected void uninstallPollTask() {
        if (null != this.pollTask) {
            this.pollTask.cancel();
        }
        if (null != this.timer) {
            this.timer.cancel();
            this.timer = null;
        }
    }

    @Override
    public final void disconnect() throws IOException {
        ConnectorRegistry.unregisterConnector(this);
        this.disconnectImpl();
        this.uninstallPollTask();
    }

    protected abstract void disconnectImpl() throws IOException;

    @Override
    public void write(CI data) throws IOException {
        this.writeImpl(this.selector.selectNorthInput(data).adaptInput(data));
    }

    protected abstract void writeImpl(I var1) throws IOException;

    protected CO received(String channel, O data) throws IOException {
        return this.received(channel, data, true);
    }

    protected CO received(String channel, O data, boolean notifyCallback) throws IOException {
        CO result = this.selector.selectSouthOutput(channel, data).adaptOutput(channel, data);
        if (null != result && null != this.callback && notifyCallback && this.checkCache(data)) {
            this.callback.received(result);
        }
        return result;
    }

    @Override
    public Class<? extends CachingStrategy> getCachingStrategyCls() {
        return this.cachingStrategy.getClass();
    }

    protected CachingStrategy getCachingStrategy() {
        return this.cachingStrategy;
    }

    protected Class<? extends CachingStrategy> getInitCachingStrategyCls() {
        return null;
    }

    protected boolean checkCache(Object data) {
        return this.cachingStrategy.checkCache(data);
    }

    @Override
    public void setReceptionCallback(ReceptionCallback<CO> callback) throws IOException {
        this.callback = callback;
    }

    @Override
    public CO request(boolean notifyCallback) throws IOException {
        return this.request(DEFAULT_CHANNEL, notifyCallback);
    }

    protected CO request(String channel, boolean notifyCallback) throws IOException {
        CO result = null;
        O data = this.read();
        if (null != data) {
            result = this.received(channel, data, notifyCallback);
        }
        return result;
    }

    @Override
    public void trigger() {
        try {
            this.request(true);
        }
        catch (IOException e) {
            LoggerFactory.getLogger(this.getClass()).error("Cannot trigger connector {}: {}", (Object)this.getName(), (Object)e.getMessage());
        }
    }

    @Override
    public void trigger(ConnectorTriggerQuery query) {
        this.trigger();
    }

    protected abstract O read() throws IOException;

    protected abstract void error(String var1, Throwable var2);

    protected void initializeModelAccess() throws IOException {
        for (int a = 0; a < this.adapter.length; ++a) {
            this.adapter[a].initializeModelAccess();
        }
    }

    @Override
    public void enableNotifications(boolean enableNotifications) {
        this.notificationsChanged(enableNotifications);
    }

    @Override
    public void notificationsChanged(boolean useNotifications) {
        if (useNotifications) {
            this.uninstallPollTask();
        } else {
            this.installPollTask();
        }
    }

    @Override
    public Class<? extends I> getProtocolInputType() {
        return this.adapter[0].getProtocolInputType();
    }

    @Override
    public Class<? extends CI> getConnectorInputType() {
        return this.adapter[0].getConnectorInputType();
    }

    @Override
    public Class<? extends O> getProtocolOutputType() {
        return this.adapter[0].getProtocolOutputType();
    }

    @Override
    public Class<? extends CO> getConnectorOutputType() {
        return this.adapter[0].getConnectorOutputType();
    }

    @Override
    public void notifyReconfigured(String parameterName, String value) {
    }

    protected class BasicAdapterProvider
    implements AdapterSelector.AdapterProvider<O, I, CO, CI> {
        protected BasicAdapterProvider() {
        }

        @Override
        public int getAdapterCount() {
            return AbstractConnector.this.adapter.length;
        }

        @Override
        public ProtocolAdapter<O, I, CO, CI> getAdapter(int index) {
            return AbstractConnector.this.adapter[index];
        }
    }
}

