/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.connectors;

import de.iip_ecosphere.platform.connectors.formatter.DummyFormatter;
import de.iip_ecosphere.platform.connectors.formatter.FormatterUtils;
import de.iip_ecosphere.platform.connectors.formatter.OutputFormatter;
import de.iip_ecosphere.platform.connectors.formatter.TextLineFormatter;
import de.iip_ecosphere.platform.transport.serialization.IipEnum;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.junit.Assert;
import org.junit.Test;
import test.de.iip_ecosphere.platform.connectors.MyEnum;

public class TextLineFormatterTest {
    @Test
    public void testFormatter() throws IOException {
        String charset = StandardCharsets.UTF_8.name();
        TextLineFormatter formatter = new TextLineFormatter(charset, "#");
        TextLineFormatter.TextLineFormatterConverter conv = formatter.getConverter();
        Assert.assertNotNull((Object)conv);
        formatter.add("field1", conv.fromString("abba"));
        formatter.add("field2", conv.fromInteger(21));
        formatter.add("field2", conv.fromDouble(1.234));
        formatter.add("field2", conv.fromFloat(1.235f));
        formatter.add("field2", conv.fromLong(3456L));
        formatter.add("field2", conv.fromBoolean(true));
        formatter.add("field3", (String)conv.fromEnum((IipEnum)MyEnum.TEST2));
        formatter.add("field3", (String)conv.fromEnumAsName((Enum)MyEnum.TEST1));
        byte[] data = formatter.chunkCompleted();
        String text = new String(data, charset);
        Assert.assertEquals((Object)("abba#21#1.234#1.235#3456#true#" + MyEnum.TEST2.getModelOrdinal() + "#" + MyEnum.TEST1.name()), (Object)text);
    }

    @Test
    public void testCreateInstance() {
        ClassLoader loader = TextLineFormatterTest.class.getClassLoader();
        Assert.assertTrue((boolean)(FormatterUtils.createInstance((ClassLoader)loader, (String)"me.here.Parser", (String)"UTF-8") instanceof DummyFormatter));
        Assert.assertNotNull((Object)FormatterUtils.createInstance((ClassLoader)loader, (String)CustomBaseFormatter.class.getName(), (String)"UTF-8"));
        OutputFormatter f = FormatterUtils.createInstance((ClassLoader)loader, (String)CustomExBaseFormatter.class.getName(), (String)"UTF-8");
        Assert.assertTrue((boolean)(f instanceof CustomExBaseFormatter));
        Assert.assertEquals((Object)"UTF-8", (Object)((CustomExBaseFormatter)f).getEncoding());
    }

    public static class CustomExBaseFormatter
    extends CustomBaseFormatter {
        private String encoding;

        public CustomExBaseFormatter(String encoding) {
            this.encoding = encoding;
        }

        public String getEncoding() {
            return this.encoding;
        }
    }

    public static class CustomBaseFormatter
    implements OutputFormatter<String> {
        public void add(String name, String data) throws IOException {
        }

        public byte[] chunkCompleted() throws IOException {
            return null;
        }

        public OutputFormatter.OutputConverter<String> getConverter() {
            return null;
        }

        public void startArrayStructure(String name) throws IOException {
        }

        public void startObjectStructure(String name) throws IOException {
        }

        public void endStructure() throws IOException {
        }
    }
}

