/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.connectors;

import de.iip_ecosphere.platform.connectors.AbstractConnector;
import de.iip_ecosphere.platform.connectors.Connector;
import de.iip_ecosphere.platform.connectors.ConnectorDescriptor;
import de.iip_ecosphere.platform.connectors.ConnectorParameter;
import de.iip_ecosphere.platform.connectors.ConnectorRegistry;
import de.iip_ecosphere.platform.connectors.ConnectorsAas;
import de.iip_ecosphere.platform.connectors.MachineConnector;
import de.iip_ecosphere.platform.connectors.types.AbstractProtocolAdapter;
import de.iip_ecosphere.platform.connectors.types.ConnectorInputTypeAdapter;
import de.iip_ecosphere.platform.connectors.types.ConnectorInputTypeTranslator;
import de.iip_ecosphere.platform.connectors.types.ConnectorOutputTypeAdapter;
import de.iip_ecosphere.platform.connectors.types.ConnectorOutputTypeTranslator;
import de.iip_ecosphere.platform.connectors.types.ProtocolAdapter;
import de.iip_ecosphere.platform.connectors.types.TranslatingProtocolAdapter;
import de.iip_ecosphere.platform.support.Server;
import de.iip_ecosphere.platform.support.aas.Aas;
import de.iip_ecosphere.platform.support.aas.AasPrintVisitor;
import de.iip_ecosphere.platform.support.aas.AasVisitor;
import de.iip_ecosphere.platform.support.aas.Property;
import de.iip_ecosphere.platform.support.aas.ReferenceElement;
import de.iip_ecosphere.platform.support.aas.Submodel;
import de.iip_ecosphere.platform.support.aas.SubmodelElementCollection;
import de.iip_ecosphere.platform.support.iip_aas.AasPartRegistry;
import de.iip_ecosphere.platform.support.iip_aas.ActiveAasBase;
import de.iip_ecosphere.platform.support.iip_aas.ClassUtility;
import de.iip_ecosphere.platform.transport.serialization.Serializer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.junit.Assert;
import org.junit.Test;

public class ConnectorsAasTest {
    private static final String NAME_CONN1 = "Connector1";
    private static final String NAME_CONN2 = "Connector2";

    private void printOut(Aas aas) {
        aas.accept((AasVisitor)new AasPrintVisitor());
    }

    @Test
    public void testAas() throws IOException {
        ActiveAasBase.NotificationMode oldP = ActiveAasBase.setNotificationMode((ActiveAasBase.NotificationMode)ActiveAasBase.NotificationMode.SYNCHRONOUS);
        ConnectorRegistry.getRegisteredConnectorDescriptorsLoader().reload();
        Assert.assertTrue((boolean)AasPartRegistry.contributorClasses().contains(ConnectorsAas.class));
        AasPartRegistry.AasBuildResult bResult = AasPartRegistry.build();
        List aasList = bResult.getAas();
        Server implServer = (Server)bResult.getProtocolServerBuilder().build();
        implServer.start();
        Aas aas = AasPartRegistry.getAas((List)aasList, (String)"IIP_Ecosphere");
        Assert.assertNotNull((Object)aas);
        this.printOut(aas);
        this.testDescriptorsSubmodel(aas);
        this.printOut(aas);
        AasPartRegistry.AasSetup oldSetup = AasPartRegistry.setAasSetup((AasPartRegistry.AasSetup)AasPartRegistry.AasSetup.createLocalEphemeralSetup());
        Server server = AasPartRegistry.deploy((List)aasList, (String[])new String[0]).start();
        Assert.assertNotNull((Object)AasPartRegistry.retrieveIipAas());
        this.testDescriptorsSubmodel(aas);
        ArrayList connectors = new ArrayList();
        this.testActiveDescriptors(connectors, 0);
        Connector1<DataOut1, DataIn1> connector1 = ConnectorsAasTest.createConnector1Instance();
        connectors.add((Connector<?, ?, ?, ?>)connector1);
        connector1.connect(null);
        System.out.println("Connected connector 1");
        this.testActiveDescriptors(connectors, 1);
        Connector2<DataOut2, DataIn2> connector2 = ConnectorsAasTest.createConnector2Instance();
        connectors.add((Connector<?, ?, ?, ?>)connector2);
        connector2.connect(null);
        System.out.println("Connected connector 2");
        this.testActiveDescriptors(connectors, 2);
        connectors.remove(connector1);
        connector1.disconnect();
        System.out.println("Disconnected connector 1");
        this.testActiveDescriptors(connectors, 1);
        connectors.remove(connector2);
        connector2.disconnect();
        System.out.println("Disconnected connector 2");
        this.testActiveDescriptors(connectors, 0);
        server.stop(true);
        implServer.stop(true);
        AasPartRegistry.setAasSetup((AasPartRegistry.AasSetup)oldSetup);
        ActiveAasBase.setNotificationMode((ActiveAasBase.NotificationMode)oldP);
    }

    private static Connector1<DataOut1, DataIn1> createConnector1Instance() {
        return new Connector1<DataOut1, DataIn1>((ProtocolAdapter<Object, Object, DataOut1, DataIn1>)new AbstractProtocolAdapter<Object, Object, DataOut1, DataIn1>(){

            public Object adaptInput(DataIn1 data) throws IOException {
                return null;
            }

            public DataOut1 adaptOutput(String channel, Object data) throws IOException {
                return null;
            }

            public Class<? extends Object> getProtocolInputType() {
                return Object.class;
            }

            public Class<? extends DataIn1> getConnectorInputType() {
                return DataIn1.class;
            }

            public Class<? extends Object> getProtocolOutputType() {
                return Object.class;
            }

            public Class<? extends DataOut1> getConnectorOutputType() {
                return DataOut1.class;
            }

            public void initializeModelAccess() throws IOException {
            }
        });
    }

    private static Connector2<DataOut2, DataIn2> createConnector2Instance() {
        Serializer<DataIn2> dataIn2Serializer = new Serializer<DataIn2>(){

            public DataIn2 from(byte[] data) throws IOException {
                return null;
            }

            public byte[] to(DataIn2 source) throws IOException {
                return null;
            }

            public DataIn2 clone(DataIn2 origin) throws IOException {
                return null;
            }

            public Class<DataIn2> getType() {
                return DataIn2.class;
            }
        };
        Serializer<DataOut2> dataOut2Serializer = new Serializer<DataOut2>(){

            public DataOut2 from(byte[] data) throws IOException {
                return null;
            }

            public byte[] to(DataOut2 source) throws IOException {
                return null;
            }

            public DataOut2 clone(DataOut2 origin) throws IOException {
                return null;
            }

            public Class<DataOut2> getType() {
                return DataOut2.class;
            }
        };
        return new Connector2<DataOut2, DataIn2>((ProtocolAdapter<byte[], byte[], DataOut2, DataIn2>)new TranslatingProtocolAdapter((ConnectorOutputTypeTranslator)new ConnectorOutputTypeAdapter((Serializer)dataOut2Serializer), (ConnectorInputTypeTranslator)new ConnectorInputTypeAdapter((Serializer)dataIn2Serializer)));
    }

    private void testDescriptorsSubmodel(Aas aas) {
        Submodel cdsm = aas.getSubmodel("installedConnectors");
        Assert.assertNotNull((Object)cdsm);
        Iterator iter = ConnectorRegistry.getRegisteredConnectorDescriptors();
        while (iter.hasNext()) {
            ConnectorDescriptor desc = (ConnectorDescriptor)iter.next();
            if (Connector1Descriptor.class != desc.getClass() && Connector2Descriptor.class != desc.getClass()) continue;
            SubmodelElementCollection sec = cdsm.getSubmodelElementCollection(ClassUtility.getName((Class)desc.getType()));
            Assert.assertNotNull((Object)sec);
            try {
                Assert.assertEquals((Object)desc.getName(), (Object)sec.getProperty("name").getValue());
                MachineConnector mc = ConnectorsAas.getMachineConnectorAnnotation(desc.getClass());
                Assert.assertNotNull((Object)mc);
                ConnectorsAasTest.assertBooleanProperty(mc.supportsEvents(), sec, "supportsEvents");
                ConnectorsAasTest.assertBooleanProperty(mc.hasModel(), sec, "hasModel");
                ConnectorsAasTest.assertBooleanProperty(mc.supportsHierarchicalQNames(), sec, "supportsQualifiedNames");
                ConnectorsAasTest.assertBooleanProperty(mc.supportsModelCalls(), sec, "supportsCalls");
                ConnectorsAasTest.assertBooleanProperty(mc.supportsModelProperties(), sec, "supportsProperties");
                ConnectorsAasTest.assertBooleanProperty(mc.supportsModelStructs(), sec, "supportsStructs");
            }
            catch (ExecutionException e) {
                Assert.fail((String)e.getMessage());
            }
        }
    }

    private static void assertBooleanProperty(boolean expected, SubmodelElementCollection sec, String propertyName) throws ExecutionException {
        Property prop = sec.getProperty(propertyName);
        Assert.assertNotNull((Object)prop);
        Assert.assertEquals((Object)expected, (Object)prop.getValue());
    }

    private static void assertStringProperty(String expected, SubmodelElementCollection sec, String propertyName) throws ExecutionException {
        Property prop = sec.getProperty(propertyName);
        Assert.assertNotNull((Object)prop);
        Assert.assertEquals((Object)expected, (Object)prop.getValue());
    }

    private static void assertReferenceElement(boolean hasRef, SubmodelElementCollection sec, String propertyName) throws ExecutionException {
        ReferenceElement refElt = sec.getReferenceElement(propertyName);
        Assert.assertNotNull((String)("RefElt " + propertyName + " on " + sec.getIdShort() + " does not exist"), (Object)refElt);
        Assert.assertNotNull((Object)refElt.getValue());
        Assert.assertEquals((Object)hasRef, (Object)refElt.getValue().hasReference());
    }

    private void testActiveDescriptors(List<Connector<?, ?, ?, ?>> connectors, int expectedActive) throws IOException {
        Aas aas = AasPartRegistry.retrieveIipAas();
        this.printOut(aas);
        System.out.println();
        Assert.assertNotNull((Object)aas);
        Submodel cdsm = aas.getSubmodel("activeConnectors");
        Assert.assertNotNull((Object)cdsm);
        Assert.assertEquals((long)expectedActive, (long)cdsm.getSubmodelElementsCount());
        for (Connector<?, ?, ?, ?> c : connectors) {
            String id = ClassUtility.getId((String)"connector_", c);
            SubmodelElementCollection connElt = cdsm.getSubmodelElementCollection(id);
            Assert.assertNotNull((Object)connElt);
            try {
                ConnectorsAasTest.assertReferenceElement(true, connElt, "inType");
                ConnectorsAasTest.assertReferenceElement(true, connElt, "outType");
                ConnectorsAasTest.assertStringProperty(c.getName(), connElt, "name");
                ConnectorsAasTest.assertReferenceElement(true, connElt, "descriptor");
            }
            catch (ExecutionException e) {
                Assert.fail((String)e.getMessage());
            }
        }
    }

    private static class DataOut2 {
        private String value1;
        private boolean value2;

        private DataOut2() {
        }
    }

    private static class DataIn2 {
        private double dData;

        private DataIn2() {
        }
    }

    private static class DataOut1 {
        private int value1;
        private int value2;

        private DataOut1() {
        }
    }

    private static class DataIn1 {
        private String data;

        private DataIn1() {
        }
    }

    private static class Connector2<CO, CI>
    extends AbstractConnector<byte[], byte[], CO, CI> {
        protected Connector2(ProtocolAdapter<byte[], byte[], CO, CI> adapter) {
            super(new ProtocolAdapter[]{adapter});
        }

        public void dispose() {
        }

        public String getName() {
            return ConnectorsAasTest.NAME_CONN2;
        }

        protected void connectImpl(ConnectorParameter params) throws IOException {
        }

        protected void disconnectImpl() throws IOException {
        }

        protected void writeImpl(byte[] data) throws IOException {
        }

        protected byte[] read() throws IOException {
            return null;
        }

        protected void error(String message, Throwable th) {
        }

        public String supportedEncryption() {
            return null;
        }

        public String enabledEncryption() {
            return null;
        }
    }

    public static class Connector2Descriptor
    implements ConnectorDescriptor {
        public String getName() {
            return ConnectorsAasTest.NAME_CONN2;
        }

        public Class<?> getType() {
            return Connector2.class;
        }
    }

    @MachineConnector(hasModel=false, supportsEvents=false, supportsHierarchicalQNames=false, supportsModelCalls=false, supportsModelProperties=false, supportsModelStructs=false)
    private static class Connector1<CO, CI>
    extends AbstractConnector<Object, Object, CO, CI> {
        protected Connector1(ProtocolAdapter<Object, Object, CO, CI> adapter) {
            super(new ProtocolAdapter[]{adapter});
        }

        public void dispose() {
        }

        public String getName() {
            return ConnectorsAasTest.NAME_CONN1;
        }

        protected void connectImpl(ConnectorParameter params) throws IOException {
        }

        protected void disconnectImpl() throws IOException {
        }

        protected void writeImpl(Object data) throws IOException {
        }

        public Object read() throws IOException {
            return null;
        }

        protected void error(String message, Throwable th) {
        }

        public String supportedEncryption() {
            return null;
        }

        public String enabledEncryption() {
            return null;
        }
    }

    public static class Connector1Descriptor
    implements ConnectorDescriptor {
        public String getName() {
            return ConnectorsAasTest.NAME_CONN1;
        }

        public Class<?> getType() {
            return Connector1.class;
        }
    }
}

