/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.connectors;

import de.iip_ecosphere.platform.connectors.Connector;
import de.iip_ecosphere.platform.connectors.ConnectorDescriptor;
import de.iip_ecosphere.platform.connectors.ConnectorParameter;
import de.iip_ecosphere.platform.connectors.ConnectorRegistry;
import de.iip_ecosphere.platform.connectors.model.AbstractModelAccess;
import de.iip_ecosphere.platform.connectors.model.ModelAccess;
import de.iip_ecosphere.platform.connectors.model.ModelInputConverter;
import de.iip_ecosphere.platform.connectors.model.ModelOutputConverter;
import de.iip_ecosphere.platform.connectors.types.AbstractConnectorInputTypeTranslator;
import de.iip_ecosphere.platform.connectors.types.AbstractConnectorOutputTypeTranslator;
import de.iip_ecosphere.platform.connectors.types.ChannelTranslatingProtocolAdapter;
import de.iip_ecosphere.platform.connectors.types.ConnectorInputTypeAdapter;
import de.iip_ecosphere.platform.connectors.types.ConnectorInputTypeTranslator;
import de.iip_ecosphere.platform.connectors.types.ConnectorOutputTypeAdapter;
import de.iip_ecosphere.platform.connectors.types.ConnectorOutputTypeTranslator;
import de.iip_ecosphere.platform.connectors.types.ProtocolAdapter;
import de.iip_ecosphere.platform.connectors.types.TranslatingProtocolAdapter;
import de.iip_ecosphere.platform.support.TimeUtils;
import de.iip_ecosphere.platform.support.aas.AasFactory;
import de.iip_ecosphere.platform.transport.connectors.ReceptionCallback;
import de.iip_ecosphere.platform.transport.serialization.Serializer;
import java.io.IOException;
import java.util.Iterator;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import test.de.iip_ecosphere.platform.connectors.MyChannelConnector;
import test.de.iip_ecosphere.platform.connectors.MyModelConnector;
import test.de.iip_ecosphere.platform.support.fakeAas.FactoryTest;
import test.de.iip_ecosphere.platform.transport.Command;
import test.de.iip_ecosphere.platform.transport.CommandJsonSerializer;
import test.de.iip_ecosphere.platform.transport.Product;
import test.de.iip_ecosphere.platform.transport.ProductJsonSerializer;

public class ConnectorTest {
    private static AasFactory original;

    @BeforeClass
    public static void init() {
        original = AasFactory.setInstance((AasFactory)FactoryTest.createDisabledFactory());
    }

    @AfterClass
    public static void shutdown() {
        AasFactory.setInstance((AasFactory)original);
    }

    public static void assertDescriptorRegistration(Class<? extends ConnectorDescriptor> cls) {
        ConnectorDescriptor found = null;
        Iterator iter = ConnectorRegistry.getRegisteredConnectorDescriptors();
        while (iter.hasNext() && null == found) {
            ConnectorDescriptor desc = (ConnectorDescriptor)iter.next();
            if (!desc.getClass().equals(cls)) continue;
            found = desc;
        }
        Assert.assertNotNull((String)("Descriptor " + cls.getName() + " not auto-registered in ConnectorRegistry"), found);
        Assert.assertTrue((found.getName().length() > 0 ? 1 : 0) != 0);
        Assert.assertNotNull((Object)found.getType());
    }

    public static void assertInstance(Connector<?, ?, ?, ?> connector, boolean registered) {
        Iterator iter = ConnectorRegistry.getRegisteredConnectorInstances();
        boolean found = false;
        while (iter.hasNext()) {
            found = iter.next() == connector;
        }
        if (registered) {
            Assert.assertTrue((boolean)found);
        } else {
            Assert.assertFalse((boolean)found);
        }
    }

    public static void assertConnectorProperties(Connector<?, ?, ?, ?> connector) {
        Assert.assertTrue((connector.getName().length() > 0 ? 1 : 0) != 0);
        Assert.assertNotNull((Object)connector.getConnectorInputType());
        Assert.assertNotNull((Object)connector.getConnectorOutputType());
        Assert.assertNotNull((Object)connector.getProtocolOutputType());
        Assert.assertNotNull((Object)connector.getProtocolInputType());
    }

    @Test
    public void testModelConnectorWithEvents() throws IOException {
        this.testModelConnector(true);
    }

    @Test
    public void testModelConnectorWithPolling() throws IOException {
        this.testModelConnector(false);
    }

    @Test
    public void testTopQName() {
        AbstractModelAccess acc = new AbstractModelAccess(null){

            public String topInstancesQName() {
                return "TOP";
            }

            public void setStruct(String qName, Object value) throws IOException {
            }

            public void set(String qName, Object value) throws IOException {
            }

            public void registerCustomType(Class<?> cls) throws IOException {
            }

            public <T> T getStruct(String qName, Class<T> type) throws IOException {
                return null;
            }

            public String getQSeparator() {
                return "/";
            }

            public Object get(String qName) throws IOException {
                return null;
            }

            public Object call(String qName, Object ... args) throws IOException {
                return null;
            }

            public void monitor(int notificationInterval, String ... qNames) throws IOException {
            }

            public void monitorModelChanges(int notificationInterval) throws IOException {
            }

            protected ConnectorParameter getConnectorParameter() {
                return null;
            }

            public ModelAccess stepInto(String name) throws IOException {
                return this;
            }

            public ModelAccess stepOut() {
                return this;
            }
        };
        Assert.assertEquals((Object)(acc.topInstancesQName() + acc.getQSeparator() + "a" + acc.getQSeparator() + "b"), (Object)acc.iqName(new String[]{"a", "", "b"}));
        Assert.assertEquals((Object)"", (Object)acc.iqName(new String[0]));
        Assert.assertEquals((Object)"", (Object)acc.iqName(new String[]{""}));
    }

    private void testModelConnector(boolean withEvents) throws IOException {
        ConnectorTest.assertDescriptorRegistration(MyModelConnector.Descriptor.class);
        ConnectorParameter params = ConnectorParameter.ConnectorParameterBuilder.newBuilder((String)"", (int)1234).build();
        ModelInputTranslator in = new ModelInputTranslator();
        ModelOutputTranslator out = new ModelOutputTranslator(withEvents);
        final Command inData = new Command("def");
        TranslatingProtocolAdapter adapter = new TranslatingProtocolAdapter((ConnectorOutputTypeTranslator)out, (ConnectorInputTypeTranslator)in);
        final MyModelConnector instance = new MyModelConnector(new ProtocolAdapter[]{adapter});
        ConnectorTest.assertConnectorProperties(instance);
        ConnectorTest.assertInstance(instance, false);
        instance.connect(params);
        ConnectorTest.assertInstance(instance, true);
        instance.setReceptionCallback((ReceptionCallback)new ReceptionCallback<Product>(){

            public void received(Product data) {
                try {
                    instance.write(inData);
                }
                catch (IOException e) {
                    Assert.fail((String)e.getMessage());
                }
            }

            public Class<Product> getType() {
                return Product.class;
            }
        });
        instance.testTrigger();
        Object received = null;
        int count = 30;
        do {
            received = instance.pollReceived();
            TimeUtils.sleep((int)100);
        } while (--count > 0 && null == received);
        Assert.assertNotNull((String)"nothing received", (Object)received);
        instance.trigger();
        ConnectorTest.assertInstance(instance, true);
        instance.disconnect();
        ConnectorTest.assertInstance(instance, false);
        instance.dispose();
    }

    @Test
    public void testConnectorParams() {
        try {
            new MyModelConnector(new ProtocolAdapter[0]);
            Assert.fail((String)"No exception thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new MyModelConnector(null);
            Assert.fail((String)"No exception thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            ModelInputTranslator in = new ModelInputTranslator();
            ModelOutputTranslator out = new ModelOutputTranslator(false);
            TranslatingProtocolAdapter adapter = new TranslatingProtocolAdapter((ConnectorOutputTypeTranslator)out, (ConnectorInputTypeTranslator)in);
            new MyModelConnector(new ProtocolAdapter[]{adapter, null});
            Assert.fail((String)"No exception thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testChannelConnector() throws IOException {
        ConnectorTest.assertDescriptorRegistration(MyChannelConnector.Descriptor.class);
        ProductJsonSerializer outSer = new ProductJsonSerializer();
        CommandJsonSerializer inSer = new CommandJsonSerializer();
        ConnectorParameter params = ConnectorParameter.ConnectorParameterBuilder.newBuilder((String)"", (int)1234).build();
        ChannelTranslatingProtocolAdapter adapter = new ChannelTranslatingProtocolAdapter("out", (ConnectorOutputTypeTranslator)new ConnectorOutputTypeAdapter((Serializer)outSer), "in", (ConnectorInputTypeTranslator)new ConnectorInputTypeAdapter((Serializer)inSer));
        final Product outData = new Product("abc", 2.3);
        final Command inData = new Command("def");
        final MyChannelConnector instance = new MyChannelConnector(adapter);
        Assert.assertNull((Object)instance.enabledEncryption());
        Assert.assertNull((Object)instance.supportedEncryption());
        ConnectorTest.assertConnectorProperties(instance);
        ConnectorTest.assertInstance(instance, false);
        instance.connect(params);
        ConnectorTest.assertInstance(instance, true);
        instance.setReceptionCallback((ReceptionCallback)new ReceptionCallback<Product>(){

            public void received(Product data) {
                Assert.assertEquals((Object)outData.getDescription(), (Object)data.getDescription());
                Assert.assertEquals((double)outData.getPrice(), (double)data.getPrice(), (double)0.01);
                try {
                    instance.write(inData);
                }
                catch (IOException e) {
                    Assert.fail((String)e.getMessage());
                }
            }

            public Class<Product> getType() {
                return Product.class;
            }
        });
        instance.offer(outSer.to(outData));
        Command received = null;
        int count = 30;
        do {
            byte[] data;
            if (null != (data = instance.pollReceived())) {
                received = inSer.from(data);
            }
            TimeUtils.sleep((int)100);
        } while (--count > 0 && null == received);
        Assert.assertNotNull((String)"nothing received", (Object)received);
        Assert.assertEquals((Object)inData.getCommand(), (Object)received.getCommand());
        ConnectorTest.assertInstance(instance, true);
        instance.disconnect();
        ConnectorTest.assertInstance(instance, false);
        instance.dispose();
    }

    private static class ModelOutputTranslator
    extends AbstractConnectorOutputTypeTranslator<Object, Product> {
        private boolean withEvents;

        private ModelOutputTranslator(boolean withEvents) {
            this.withEvents = withEvents;
        }

        public void initializeModelAccess() throws IOException {
            ModelAccess acc = this.getModelAccess();
            ModelOutputConverter oConv = acc.getOutputConverter();
            acc.set("iProp", oConv.fromInteger(10));
            acc.set("sProp", oConv.fromString("HERE"));
            acc.set("dProp", oConv.fromDouble(2.3));
            acc.setStruct("struct", (Object)new MyStruct("xmas"));
            acc.useNotifications(this.withEvents);
        }

        public Product to(Object source) throws IOException {
            ModelAccess acc = this.getModelAccess();
            ModelInputConverter iConv = acc.getInputConverter();
            Assert.assertTrue((acc.getQSeparator().length() > 0 ? 1 : 0) != 0);
            Assert.assertEquals((Object)"", (Object)acc.qName(new String[0]));
            Assert.assertEquals((Object)"", (Object)acc.qName(new String[]{""}));
            Assert.assertEquals((Object)("a" + acc.getQSeparator() + "b" + acc.getQSeparator() + "c"), (Object)acc.qName(new String[]{"a", "b", "c"}));
            Assert.assertEquals((Object)("a" + acc.getQSeparator() + "b" + acc.getQSeparator() + "c"), (Object)acc.qName(new String[]{"", "a", "b", "c"}));
            Assert.assertEquals((Object)("a" + acc.getQSeparator() + "b" + acc.getQSeparator() + "c"), (Object)acc.qName(new String[]{"a", "", "b", "c"}));
            Assert.assertEquals((Object)("a" + acc.getQSeparator() + "b"), (Object)acc.iqName(new String[]{"a", "", "b"}));
            Assert.assertEquals((Object)"", (Object)acc.iqName(new String[0]));
            Assert.assertEquals((Object)"", (Object)acc.iqName(new String[]{""}));
            Assert.assertEquals((long)10L, (long)iConv.toInteger(acc.get("iProp")));
            MyStruct s = (MyStruct)acc.getStruct("struct", MyStruct.class);
            Assert.assertNotNull((Object)s);
            Assert.assertEquals((Object)"xmas", (Object)s.data);
            return new Product(iConv.toString(acc.get("sProp")), iConv.toDouble(acc.get("dProp")));
        }

        public Class<? extends Object> getSourceType() {
            return Object.class;
        }

        public Class<? extends Product> getTargetType() {
            return Product.class;
        }
    }

    private static class ModelInputTranslator
    extends AbstractConnectorInputTypeTranslator<Command, Object> {
        private ModelInputTranslator() {
        }

        public Object from(Command data) throws IOException {
            ModelAccess acc = this.getModelAccess();
            ModelInputConverter inConv = acc.getInputConverter();
            ModelOutputConverter outConv = acc.getOutputConverter();
            acc.set("sProp", outConv.fromString(data.getCommand()));
            Assert.assertEquals((long)10L, (long)inConv.toInteger(acc.get("iProp")));
            Assert.assertEquals((Object)data.getCommand(), (Object)inConv.toString(acc.get("sProp")));
            Assert.assertEquals((double)2.3, (double)inConv.toDouble(acc.get("dProp")), (double)0.01);
            MyStruct s = (MyStruct)acc.getStruct("struct", MyStruct.class);
            Assert.assertNotNull((Object)s);
            Assert.assertEquals((Object)"xmas", (Object)s.data);
            return new Object();
        }

        public Class<? extends Object> getSourceType() {
            return Object.class;
        }

        public Class<? extends Command> getTargetType() {
            return Command.class;
        }
    }

    private static class MyStruct {
        private String data;

        private MyStruct(String data) {
            this.data = data;
        }
    }
}

