/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.connectors;

import de.iip_ecosphere.platform.connectors.AbstractChannelConnector;
import de.iip_ecosphere.platform.connectors.AbstractConnector;
import de.iip_ecosphere.platform.connectors.Connector;
import de.iip_ecosphere.platform.connectors.ConnectorFactory;
import de.iip_ecosphere.platform.connectors.ConnectorParameter;
import de.iip_ecosphere.platform.connectors.model.ModelAccess;
import de.iip_ecosphere.platform.connectors.types.ChannelProtocolAdapter;
import de.iip_ecosphere.platform.connectors.types.ProtocolAdapter;
import de.iip_ecosphere.platform.support.iip_aas.NameplateSetup;
import de.iip_ecosphere.platform.support.iip_aas.Version;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;

public class ConnectorFactoryTest {
    @Test
    public void testFactory() {
        ConnectorParameter v0p = ConnectorParameter.ConnectorParameterBuilder.newBuilder((String)"l", (int)0).build();
        NameplateSetup.Service s3 = new NameplateSetup.Service();
        s3.setVersion(new Version(new int[]{3}));
        ConnectorParameter v3p = ConnectorParameter.ConnectorParameterBuilder.newBuilder((String)"l", (int)0).setService(s3).build();
        NameplateSetup.Service s5 = new NameplateSetup.Service();
        s5.setVersion(new Version(new int[]{5}));
        ConnectorParameter v5p = ConnectorParameter.ConnectorParameterBuilder.newBuilder((String)"l", (int)0).setService(s5).build();
        Connector oc = ConnectorFactory.createConnector((String)MyOpcUaConnector.class.getName(), () -> v3p, (ProtocolAdapter[])new MyOpcProtocolAdapter[]{new MyOpcProtocolAdapter()});
        Assert.assertTrue((boolean)(oc instanceof MyOpcUaConnector));
        Connector mc = ConnectorFactory.createConnector((String)MyMqttConnectorFactory.class.getName(), () -> v5p, (ProtocolAdapter[])new MyMqttProtocolAdapter[]{new MyMqttProtocolAdapter()});
        Assert.assertTrue((boolean)(mc instanceof MyMqttv5Connector));
        mc = ConnectorFactory.createConnector((String)MyMqttConnectorFactory.class.getName(), () -> v3p, (ProtocolAdapter[])new MyMqttProtocolAdapter[]{new MyMqttProtocolAdapter()});
        Assert.assertTrue((boolean)(mc instanceof MyMqttv3Connector));
        mc = ConnectorFactory.createConnector((String)MyMqttConnectorFactory.class.getName(), () -> v0p, (ProtocolAdapter[])new MyMqttProtocolAdapter[]{new MyMqttProtocolAdapter()});
        Assert.assertTrue((boolean)(mc instanceof MyMqttv3Connector));
    }

    public static class MyOpcProtocolAdapter
    implements ProtocolAdapter<DataItem, Object, Object, Object> {
        public Object adaptInput(Object data) throws IOException {
            return null;
        }

        public Object adaptOutput(String channel, DataItem data) throws IOException {
            return null;
        }

        public Class<? extends Object> getProtocolInputType() {
            return Object.class;
        }

        public Class<? extends Object> getConnectorInputType() {
            return Object.class;
        }

        public Class<? extends DataItem> getProtocolOutputType() {
            return DataItem.class;
        }

        public Class<? extends Object> getConnectorOutputType() {
            return Object.class;
        }

        public ModelAccess getModelAccess() {
            return null;
        }

        public void setModelAccess(ModelAccess modelAccess) {
        }

        public void initializeModelAccess() throws IOException {
        }
    }

    public static class MyOpcUaConnector<CO, CI>
    extends AbstractConnector<DataItem, Object, CO, CI> {
        @SafeVarargs
        public MyOpcUaConnector(ProtocolAdapter<DataItem, Object, CO, CI> ... adapter) {
            super(null, adapter);
        }

        public void dispose() {
        }

        public String supportedEncryption() {
            return null;
        }

        public String enabledEncryption() {
            return null;
        }

        public String getName() {
            return "MyOpcUa";
        }

        protected void connectImpl(ConnectorParameter params) throws IOException {
        }

        protected void disconnectImpl() throws IOException {
        }

        protected void writeImpl(Object data) throws IOException {
        }

        protected DataItem read() throws IOException {
            return null;
        }

        protected void error(String message, Throwable th) {
        }
    }

    public static class DataItem {
    }

    public static class MyMqttProtocolAdapter
    implements ChannelProtocolAdapter<byte[], byte[], Object, Object> {
        public byte[] adaptInput(Object data) throws IOException {
            return null;
        }

        public Object adaptOutput(String channel, byte[] data) throws IOException {
            return null;
        }

        public Class<? extends byte[]> getProtocolInputType() {
            return byte[].class;
        }

        public Class<? extends Object> getConnectorInputType() {
            return Object.class;
        }

        public Class<? extends byte[]> getProtocolOutputType() {
            return byte[].class;
        }

        public Class<? extends Object> getConnectorOutputType() {
            return Object.class;
        }

        public ModelAccess getModelAccess() {
            return null;
        }

        public void setModelAccess(ModelAccess modelAccess) {
        }

        public void initializeModelAccess() throws IOException {
        }

        public String getInputChannel() {
            return null;
        }

        public String getOutputChannel() {
            return null;
        }
    }

    public static class MyMqttv5Connector<CO, CI>
    extends AbstractChannelConnector<byte[], byte[], CO, CI> {
        @SafeVarargs
        public MyMqttv5Connector(ChannelProtocolAdapter<byte[], byte[], CO, CI> ... adapter) {
            super(null, adapter);
        }

        public void dispose() {
        }

        public String supportedEncryption() {
            return null;
        }

        public String enabledEncryption() {
            return null;
        }

        public String getName() {
            return "MyMqttv5";
        }

        protected void writeImpl(byte[] data, String channel) throws IOException {
        }

        protected void connectImpl(ConnectorParameter params) throws IOException {
        }

        protected void disconnectImpl() throws IOException {
        }

        protected byte[] read() throws IOException {
            return null;
        }

        protected void error(String message, Throwable th) {
        }
    }

    public static class MyMqttv3Connector<CO, CI>
    extends AbstractChannelConnector<byte[], byte[], CO, CI> {
        @SafeVarargs
        public MyMqttv3Connector(ChannelProtocolAdapter<byte[], byte[], CO, CI> ... adapter) {
            super(null, adapter);
        }

        public void dispose() {
        }

        public String supportedEncryption() {
            return null;
        }

        public String enabledEncryption() {
            return null;
        }

        public String getName() {
            return "MyMqttv3";
        }

        protected void writeImpl(byte[] data, String channel) throws IOException {
        }

        protected void connectImpl(ConnectorParameter params) throws IOException {
        }

        protected void disconnectImpl() throws IOException {
        }

        protected byte[] read() throws IOException {
            return null;
        }

        protected void error(String message, Throwable th) {
        }
    }

    public static class MyMqttConnectorFactory<CO, CI>
    implements ConnectorFactory<byte[], byte[], CO, CI, ChannelProtocolAdapter<byte[], byte[], CO, CI>> {
        public Connector<byte[], byte[], CO, CI> createConnector(ConnectorParameter params, ChannelProtocolAdapter<byte[], byte[], CO, CI> ... adapter) {
            AbstractChannelConnector result = ConnectorFactory.hasVersion((ConnectorParameter)params) && params.getService().getVersion().getSegment(0) == 5 ? new MyMqttv5Connector<CO, CI>(adapter) : new MyMqttv3Connector<CO, CI>(adapter);
            return result;
        }
    }
}

