/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.connectors;

import de.iip_ecosphere.platform.connectors.Connector;
import de.iip_ecosphere.platform.connectors.ConnectorDescriptor;
import de.iip_ecosphere.platform.connectors.ConnectorParameter;
import de.iip_ecosphere.platform.connectors.types.ChannelProtocolAdapter;
import de.iip_ecosphere.platform.connectors.types.ChannelTranslatingProtocolAdapter;
import de.iip_ecosphere.platform.connectors.types.ChanneledConnectorOutputTypeAdapter;
import de.iip_ecosphere.platform.connectors.types.ConnectorInputTypeAdapter;
import de.iip_ecosphere.platform.connectors.types.ConnectorInputTypeTranslator;
import de.iip_ecosphere.platform.connectors.types.ConnectorOutputTypeAdapter;
import de.iip_ecosphere.platform.connectors.types.ConnectorOutputTypeTranslator;
import de.iip_ecosphere.platform.support.Schema;
import de.iip_ecosphere.platform.support.Server;
import de.iip_ecosphere.platform.support.ServerAddress;
import de.iip_ecosphere.platform.support.TimeUtils;
import de.iip_ecosphere.platform.transport.connectors.ReceptionCallback;
import de.iip_ecosphere.platform.transport.connectors.TransportConnector;
import de.iip_ecosphere.platform.transport.connectors.TransportParameter;
import de.iip_ecosphere.platform.transport.serialization.Serializer;
import de.iip_ecosphere.platform.transport.serialization.SerializerRegistry;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;
import test.de.iip_ecosphere.platform.connectors.ConnectorTest;
import test.de.iip_ecosphere.platform.transport.AbstractTransportConnectorTest;
import test.de.iip_ecosphere.platform.transport.Command;
import test.de.iip_ecosphere.platform.transport.CommandJsonSerializer;
import test.de.iip_ecosphere.platform.transport.Product;
import test.de.iip_ecosphere.platform.transport.ProductJsonSerializer;

public abstract class AbstractSerializingConnectorTest {
    private static final String CMD_CHANNEL = "cmd";
    private static final String PROD_CHANNEL = "prod";

    protected abstract Connector<byte[], byte[], Product, Command> createConnector(ChannelProtocolAdapter<byte[], byte[], Product, Command> ... var1);

    protected abstract Class<? extends ConnectorDescriptor> getConnectorDescriptor();

    protected abstract Server createTestServer(ServerAddress var1, File var2);

    protected abstract TransportConnector createTransportConnector();

    protected abstract TransportParameter.TransportParameterBuilder configureTransportParameter(TransportParameter.TransportParameterBuilder var1);

    @Test
    public void testConnector() throws IOException {
        ConnectorParameterConfigurer configurer = this.getConfigurer(false);
        ServerAddress addr = new ServerAddress(Schema.IGNORE);
        Server server = this.createTestServer(addr, null);
        server.start();
        this.doTest(addr, configurer);
        this.doTestMultiChannel(addr, configurer);
        server.stop(true);
    }

    @Test
    public void testTlsConnector() throws IOException {
        ConnectorParameterConfigurer configurer = this.getConfigurer(true);
        if (null == configurer) {
            System.out.println("No TLS test performed, no connector.");
        } else {
            ServerAddress addr = new ServerAddress(Schema.IGNORE);
            Server server = this.createTestServer(addr, configurer.getConfigDir());
            server.start();
            this.doTest(addr, configurer);
            this.doTestMultiChannel(addr, configurer);
            server.stop(true);
        }
    }

    protected abstract ConnectorParameterConfigurer getConfigurer(boolean var1);

    protected abstract boolean implementsEncryption();

    protected ConnectorParameter createConnectorParameter(ServerAddress addr, ConnectorParameterConfigurer configurer) {
        ConnectorParameter.ConnectorParameterBuilder cBuilder = ConnectorParameter.ConnectorParameterBuilder.newBuilder((String)addr.getHost(), (int)addr.getPort()).setApplicationInformation("m1", "");
        if (null != configurer) {
            configurer.configure(cBuilder);
        }
        return cBuilder.build();
    }

    protected TransportParameter createTransportParameter(ServerAddress addr, AbstractTransportConnectorTest.TransportParameterConfigurer configurer) {
        TransportParameter.TransportParameterBuilder tBuilder = TransportParameter.TransportParameterBuilder.newBuilder((String)addr.getHost(), (int)addr.getPort());
        if (null != configurer) {
            configurer.configure(tBuilder);
        }
        return this.configureTransportParameter(tBuilder).build();
    }

    protected void doTest(ServerAddress addr, ConnectorParameterConfigurer configurer) throws IOException {
        ConnectorTest.assertDescriptorRegistration(this.getConnectorDescriptor());
        Product prod1 = new Product("prod1", 10.2);
        Product prod2 = new Product("prod2", 5.1);
        System.out.println("Using JSON serializers");
        ConnectorParameter cParams = this.createConnectorParameter(addr, configurer);
        TransportParameter tParams = this.createTransportParameter(addr, configurer);
        ProductJsonSerializer outSer = new ProductJsonSerializer();
        SerializerRegistry.registerSerializer((Serializer)outSer);
        CommandJsonSerializer inSer = new CommandJsonSerializer();
        SerializerRegistry.registerSerializer((Serializer)inSer);
        final Connector<byte[], byte[], Product, Command> mConnector = this.createConnector(new ChannelProtocolAdapter[]{new ChannelTranslatingProtocolAdapter(PROD_CHANNEL, (ConnectorOutputTypeTranslator)new ConnectorOutputTypeAdapter((Serializer)outSer), CMD_CHANNEL, (ConnectorInputTypeTranslator)new ConnectorInputTypeAdapter((Serializer)inSer))});
        ConnectorTest.assertInstance(mConnector, false);
        ConnectorTest.assertConnectorProperties(mConnector);
        this.testEnc(mConnector, configurer, false);
        mConnector.connect(cParams);
        this.testEnc(mConnector, configurer, true);
        ConnectorTest.assertInstance(mConnector, true);
        mConnector.setReceptionCallback((ReceptionCallback)new ReceptionCallback<Product>(){

            public void received(Product data) {
                try {
                    mConnector.write((Object)new Command(data.getDescription()));
                }
                catch (IOException e) {
                    System.out.println("ERROR WHILE SENDING: " + e.getMessage());
                }
            }

            public Class<Product> getType() {
                return Product.class;
            }
        });
        TransportConnector tConnector = this.createTransportConnector();
        tConnector.connect(tParams);
        final ArrayList received = new ArrayList();
        tConnector.setReceptionCallback(CMD_CHANNEL, (ReceptionCallback)new ReceptionCallback<Command>(){

            public void received(Command cmd) {
                received.add(cmd);
            }

            public Class<Command> getType() {
                return Command.class;
            }
        });
        tConnector.syncSend(PROD_CHANNEL, (Object)prod1);
        tConnector.syncSend(PROD_CHANNEL, (Object)prod2);
        for (int count = 20; received.size() < 2 && count > 0; --count) {
            TimeUtils.sleep((int)100);
        }
        System.out.println("Cleaning up");
        ConnectorTest.assertInstance(mConnector, true);
        mConnector.disconnect();
        tConnector.disconnect();
        ConnectorTest.assertInstance(mConnector, false);
        SerializerRegistry.unregisterSerializer((Serializer)outSer);
        SerializerRegistry.unregisterSerializer((Serializer)inSer);
        mConnector.dispose();
        Assert.assertEquals((long)2L, (long)received.size());
        Assert.assertEquals((Object)prod1.getDescription(), (Object)((Command)received.get(0)).getCommand());
        Assert.assertEquals((Object)prod2.getDescription(), (Object)((Command)received.get(1)).getCommand());
    }

    protected void doTestMultiChannel(ServerAddress addr, ConnectorParameterConfigurer configurer) throws IOException {
        String prodChannel1 = "data/channel/prod1";
        String prodChannel2 = "data/channel/prod2";
        String prodChannelDyn = "data/channel/+";
        Product prod1 = new Product("prod1", 10.2);
        Product prod2 = new Product("prod2", 4.1);
        ChanneledProductJsonSerializer outSer = new ChanneledProductJsonSerializer();
        SerializerRegistry.registerSerializer((Serializer)outSer);
        CommandJsonSerializer inSer = new CommandJsonSerializer();
        SerializerRegistry.registerSerializer((Serializer)inSer);
        ConnectorParameter cParams = this.createConnectorParameter(addr, configurer);
        TransportParameter tParams = this.createTransportParameter(addr, configurer);
        Connector<byte[], byte[], Product, Command> cConnector = this.createConnector(new ChannelProtocolAdapter[]{new ChannelTranslatingProtocolAdapter("data/channel/prod1", (ConnectorOutputTypeTranslator)new ConnectorOutputTypeAdapter((Serializer)outSer), CMD_CHANNEL, (ConnectorInputTypeTranslator)new ConnectorInputTypeAdapter((Serializer)inSer)), new ChannelTranslatingProtocolAdapter("data/channel/prod2", (ConnectorOutputTypeTranslator)new ConnectorOutputTypeAdapter((Serializer)outSer), CMD_CHANNEL, (ConnectorInputTypeTranslator)new ConnectorInputTypeAdapter((Serializer)inSer))});
        cConnector.connect(cParams);
        CountingProductReceptionCallback cCallback = new CountingProductReceptionCallback();
        cConnector.setReceptionCallback((ReceptionCallback)cCallback);
        Connector<byte[], byte[], Product, Command> dConnector = this.createConnector(new ChannelProtocolAdapter[]{new ChannelTranslatingProtocolAdapter("data/channel/+", (ConnectorOutputTypeTranslator)new ChanneledConnectorOutputTypeAdapter((ChanneledConnectorOutputTypeAdapter.ChanneledSerializer)outSer), CMD_CHANNEL, (ConnectorInputTypeTranslator)new ConnectorInputTypeAdapter((Serializer)inSer))});
        dConnector.connect(cParams);
        CountingProductReceptionCallback dCallback = new CountingProductReceptionCallback();
        dConnector.setReceptionCallback((ReceptionCallback)dCallback);
        TransportConnector tConnector = this.createTransportConnector();
        tConnector.connect(tParams);
        tConnector.syncSend("data/channel/prod1", (Object)prod1);
        tConnector.syncSend("data/channel/prod2", (Object)prod2);
        cConnector.disconnect();
        tConnector.disconnect();
        SerializerRegistry.unregisterSerializer((Serializer)outSer);
        SerializerRegistry.unregisterSerializer((Serializer)inSer);
        Assert.assertEquals((long)2L, (long)cCallback.getCounter());
        Assert.assertEquals((long)2L, (long)dCallback.getCounter());
    }

    private void testEnc(Connector<?, ?, ?, ?> connector, ConnectorParameterConfigurer configurer, boolean connected) {
        if (this.implementsEncryption()) {
            Assert.assertTrue((connector.supportedEncryption().length() > 0 ? 1 : 0) != 0);
        } else {
            Assert.assertTrue((connector.supportedEncryption() == null || connector.supportedEncryption().length() == 0 ? 1 : 0) != 0);
        }
        if (null == configurer || !connected) {
            Assert.assertTrue((connector.enabledEncryption() == null || connector.enabledEncryption().length() == 0 ? 1 : 0) != 0);
        } else if (configurer.withEncryption()) {
            Assert.assertTrue((connector.enabledEncryption().length() > 0 ? 1 : 0) != 0);
        }
    }

    private static class ChanneledProductJsonSerializer
    extends ProductJsonSerializer
    implements ChanneledConnectorOutputTypeAdapter.ChanneledSerializer<Product> {
        private ChanneledProductJsonSerializer() {
        }

        public Product from(String channel, byte[] data) throws IOException {
            Assert.assertNotNull((Object)channel);
            Assert.assertTrue((channel.length() > 0 ? 1 : 0) != 0);
            return super.from(data);
        }
    }

    private static class CountingProductReceptionCallback
    implements ReceptionCallback<Product> {
        private int counter;

        private CountingProductReceptionCallback() {
        }

        public void received(Product data) {
            ++this.counter;
        }

        public Class<Product> getType() {
            return Product.class;
        }

        public int getCounter() {
            return this.counter;
        }
    }

    public static interface ConnectorParameterConfigurer
    extends AbstractTransportConnectorTest.TransportParameterConfigurer {
        public void configure(ConnectorParameter.ConnectorParameterBuilder var1);

        public File getConfigDir();

        public boolean withEncryption();
    }
}

