/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.connectors.types;

import de.iip_ecosphere.platform.connectors.model.ModelAccess;
import de.iip_ecosphere.platform.connectors.types.AbstractProtocolAdapter;
import de.iip_ecosphere.platform.connectors.types.ConnectorInputTypeTranslator;
import de.iip_ecosphere.platform.connectors.types.ConnectorOutputTypeTranslator;
import java.io.IOException;

public class TranslatingProtocolAdapter<O, I, CO, CI>
extends AbstractProtocolAdapter<O, I, CO, CI> {
    private ConnectorOutputTypeTranslator<O, CO> outputTranslator;
    private ConnectorInputTypeTranslator<CI, I> inputTranslator;

    public TranslatingProtocolAdapter(ConnectorOutputTypeTranslator<O, CO> outputTranslator, ConnectorInputTypeTranslator<CI, I> inputTranslator) {
        this.outputTranslator = outputTranslator;
        this.inputTranslator = inputTranslator;
    }

    @Override
    public I adaptInput(CI data) throws IOException {
        return (I)this.inputTranslator.from(data);
    }

    @Override
    public CO adaptOutput(O data) throws IOException {
        return (CO)this.outputTranslator.to(data);
    }

    @Override
    public void setModelAccess(ModelAccess modelAccess) {
        super.setModelAccess(modelAccess);
        this.outputTranslator.setModelAccess(modelAccess);
        this.inputTranslator.setModelAccess(modelAccess);
    }

    @Override
    public void initializeModelAccess() throws IOException {
        this.outputTranslator.initializeModelAccess();
    }

    @Override
    public Class<? extends I> getProtocolInputType() {
        return this.inputTranslator.getSourceType();
    }

    @Override
    public Class<? extends CI> getConnectorInputType() {
        return this.inputTranslator.getTargetType();
    }

    @Override
    public Class<? extends O> getProtocolOutputType() {
        return this.outputTranslator.getSourceType();
    }

    @Override
    public Class<? extends CO> getConnectorOutputType() {
        return this.outputTranslator.getTargetType();
    }
}

