/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.connectors.parser;

import com.jsoniter.JsonIterator;
import com.jsoniter.ValueType;
import com.jsoniter.any.Any;
import com.jsoniter.spi.JsonException;
import de.iip_ecosphere.platform.connectors.formatter.FormatCache;
import de.iip_ecosphere.platform.connectors.parser.InputParser;
import de.iip_ecosphere.platform.connectors.parser.MachineParser;
import de.iip_ecosphere.platform.support.function.IOConsumer;
import de.iip_ecosphere.platform.support.iip_aas.json.JsonUtils;
import java.io.IOException;
import java.lang.reflect.Field;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import org.slf4j.LoggerFactory;

@MachineParser
public final class JsonInputParser
implements InputParser<Any> {
    private static final JsonInputConverter CONVERTER = new JsonInputConverter();
    private static final Class<?> LAZY_ANY_CLS;
    private static final Field LAZY_ANY_HEAD_FIELD;
    private static final Field LAZY_ANY_TAIL_FIELD;

    public JsonParseResult parse(byte[] data) throws IOException {
        return new JsonParseResult(data);
    }

    public JsonInputConverter getConverter() {
        return CONVERTER;
    }

    static {
        Class cls = JsonInputConverter.class;
        Field hf = null;
        Field tf = null;
        try {
            cls = Class.forName("com.jsoniter.any.LazyAny");
            hf = cls.getDeclaredField("head");
            hf.setAccessible(true);
            tf = cls.getDeclaredField("tail");
            tf.setAccessible(true);
        }
        catch (ClassNotFoundException | NoSuchFieldException e) {
            LoggerFactory.getLogger(JsonInputParser.class).error("Cannot find LazyAny class or its fields: " + e.getMessage() + " Disabling JSON stepIn-slicing.");
        }
        if (tf == null) {
            cls = JsonInputConverter.class;
            tf = null;
        }
        LAZY_ANY_CLS = cls;
        LAZY_ANY_HEAD_FIELD = hf;
        LAZY_ANY_TAIL_FIELD = tf;
    }

    public static final class JsonInputConverter
    implements InputParser.InputConverter<Any> {
        @Override
        public int toInteger(Any data) throws IOException {
            try {
                return data.toInt();
            }
            catch (JsonException e) {
                throw new IOException(e);
            }
        }

        @Override
        public long toLong(Any data) throws IOException {
            try {
                return data.toLong();
            }
            catch (JsonException e) {
                throw new IOException(e);
            }
        }

        @Override
        public short toShort(Any data) throws IOException {
            try {
                return (short)data.toInt();
            }
            catch (JsonException e) {
                throw new IOException(e);
            }
        }

        @Override
        public String toString(Any data) throws IOException {
            try {
                return data.toString();
            }
            catch (JsonException e) {
                throw new IOException(e);
            }
        }

        @Override
        public double toDouble(Any data) throws IOException {
            try {
                return data.toDouble();
            }
            catch (JsonException e) {
                throw new IOException(e);
            }
        }

        @Override
        public float toFloat(Any data) throws IOException {
            try {
                return data.toFloat();
            }
            catch (JsonException e) {
                throw new IOException(e);
            }
        }

        @Override
        public boolean toBoolean(Any data) throws IOException {
            try {
                return data.toBoolean();
            }
            catch (JsonException e) {
                throw new IOException(e);
            }
        }

        @Override
        public int[] toIntegerArray(Any data) throws IOException {
            int[] dta = new int[data.size()];
            for (int j = 0; j < dta.length; ++j) {
                dta[j] = data.get(j).toInt();
            }
            return dta;
        }

        @Override
        public double[] toDoubleArray(Any data) throws IOException {
            double[] dta = new double[data.size()];
            for (int j = 0; j < dta.length; ++j) {
                dta[j] = Double.parseDouble(data.get(j).toString());
            }
            return dta;
        }

        @Override
        public Object toObject(Any data) throws IOException {
            return null;
        }

        @Override
        public Date toDate(Any data, String format) throws IOException {
            SimpleDateFormat f = FormatCache.getDateFormatter(format);
            try {
                return f.parse(data.toString());
            }
            catch (ParseException e) {
                throw new IOException(e);
            }
        }
    }

    public static final class JsonParseResult
    implements InputParser.ParseResult<Any> {
        private Any any;
        private byte[] data;
        private JsonParseResult parent;

        private JsonParseResult(byte[] data) {
            this(data, JsonIterator.deserialize((byte[])data), null);
        }

        private JsonParseResult(byte[] data, Any any, JsonParseResult parent) {
            this.any = any;
            this.data = data;
            this.parent = parent;
        }

        @Override
        public int getDataCount() {
            return this.any.size();
        }

        @Override
        public String getFieldName(IOConsumer<Any> valueCons, int ... indexes) throws IOException {
            String result = "";
            if (this.any.size() == 1 && indexes.length == 1) {
                result = ((String)this.any.asMap().keySet().iterator().next()).toString();
                if (null != valueCons) {
                    valueCons.accept((Object)this.any.get((Object)result));
                }
            } else {
                Any.EntryIterator it = this.findBy(indexes);
                if (null != it) {
                    result = it.key();
                    if (null != valueCons) {
                        valueCons.accept((Object)it.value());
                    }
                }
            }
            return result;
        }

        private Any.EntryIterator findBy(int[] indexes) {
            Any.EntryIterator result = null;
            if (indexes.length > 0) {
                Any tmp = Any.lazyObject((byte[])this.data, (int)0, (int)(this.data.length - 1));
                for (int i = 0; i < indexes.length; ++i) {
                    Any.EntryIterator it = tmp.entries();
                    for (int pos = indexes[i]; pos >= 0 && it.next(); --pos) {
                        if (pos != 0) continue;
                        if (i < indexes.length - 1) {
                            tmp = it.value();
                            if (tmp.valueType() != ValueType.STRING) continue;
                            tmp = JsonIterator.deserialize((String)tmp.toString());
                            continue;
                        }
                        result = it;
                    }
                }
            }
            return result;
        }

        private Any.EntryIterator findBy(int index) {
            Any.EntryIterator result = null;
            Any tmp = Any.lazyObject((byte[])this.data, (int)0, (int)(this.data.length - 1));
            Any.EntryIterator it = tmp.entries();
            while (index >= 0 && it.next()) {
                if (index == 0) {
                    result = it;
                }
                --index;
            }
            return result;
        }

        @Override
        public Any getData(String name, int ... indexes) throws IOException {
            Any result = this.get(name, indexes);
            if (result != null) {
                return result;
            }
            throw new IOException("No entry found for " + name + " / " + Arrays.toString(indexes));
        }

        private Any get(String name, int ... indexes) {
            Any result = null;
            Any obj = this.any;
            int start = 0;
            int end = 0;
            do {
                if (obj.valueType() == ValueType.STRING) {
                    obj = JsonIterator.deserialize((String)obj.toString());
                }
                if ((end = name.indexOf(46, start)) > 0) {
                    obj = obj.get((Object)name.substring(start, end));
                    start = end + 1;
                    continue;
                }
                obj = 0 == start ? obj.get((Object)name) : obj.get((Object)name.substring(start, name.length()));
            } while (end > 0);
            if (obj.valueType() == ValueType.INVALID && indexes.length > 0) {
                Any.EntryIterator it = this.findBy(indexes);
                if (null != it) {
                    result = it.value();
                }
            } else if (obj.valueType() != ValueType.INVALID && obj != this.any) {
                result = obj;
            }
            return result;
        }

        @Override
        public void getData(IOConsumer<Any> ifPresent, String name, int ... indexes) throws IOException {
            Any result = this.get(name, indexes);
            if (null != result) {
                ifPresent.accept((Object)result);
            }
        }

        private Any getLocal(String name, int[] indexes) {
            Any.EntryIterator it;
            Any result = null;
            if (this.any.keys().contains(name)) {
                result = this.any.get((Object)name);
            } else if (indexes.length > 0 && null != (it = this.findBy(indexes))) {
                result = it.value();
            }
            return result;
        }

        @Override
        public Any getLocalData(String name, int ... indexes) throws IOException {
            Any result = this.getLocal(name, indexes);
            if (null == result) {
                throw new IOException("No entry found for " + name + " / " + Arrays.toString(indexes));
            }
            return result;
        }

        @Override
        public void getLocalData(IOConsumer<Any> ifPresent, String name, int ... indexes) throws IOException {
            Any result = this.getLocal(name, indexes);
            if (null != result) {
                ifPresent.accept((Object)result);
            }
        }

        public JsonParseResult stepInto(String name, int index) throws IOException {
            Any nested = this.any.get((Object)name);
            boolean deserialized = false;
            if (nested.valueType() == ValueType.INVALID) {
                Any.EntryIterator it = this.findBy(index);
                if (null != it) {
                    nested = it.value();
                } else {
                    throw new IndexOutOfBoundsException("No entry found for " + index);
                }
            }
            if (nested.valueType() != ValueType.INVALID) {
                byte[] topData;
                if (nested.valueType() == ValueType.STRING) {
                    nested = JsonIterator.deserialize((String)nested.toString());
                    deserialized = true;
                }
                byte[] actData = topData = this.getTopData();
                if (LAZY_ANY_CLS.isInstance(nested)) {
                    try {
                        int head = (Integer)LAZY_ANY_HEAD_FIELD.get(nested);
                        int tail = (Integer)LAZY_ANY_TAIL_FIELD.get(nested);
                        actData = new byte[tail - head];
                        System.arraycopy(topData, head, actData, 0, actData.length);
                        if (deserialized) {
                            String tmp = JsonUtils.unescape((String)new String(actData));
                            actData = tmp.getBytes();
                        }
                    }
                    catch (IllegalAccessException e) {
                        throw new IOException("Cannot determine head/tail to slice input data: " + e.getMessage());
                    }
                }
                return new JsonParseResult(actData, nested, this);
            }
            throw new IOException("Cannot determine element for " + name + " index: " + index);
        }

        private byte[] getTopData() {
            JsonParseResult ptr = this;
            while (ptr.parent != null) {
                ptr = ptr.parent;
            }
            return ptr.data;
        }

        public JsonParseResult stepOut() {
            return this.parent;
        }
    }
}

