/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.connectors.parser;

import de.iip_ecosphere.platform.connectors.parser.InputParser;
import de.iip_ecosphere.platform.support.function.IOConsumer;
import java.io.IOException;

public class ArrayParseResult
implements InputParser.ParseResult<String> {
    private String[] data;
    private ArrayParseResult parent;
    private int baseIndex;

    protected ArrayParseResult(String[] data) {
        this(data, 0, null);
    }

    protected ArrayParseResult(String[] data, int baseIndex, ArrayParseResult parent) {
        this.data = data;
        this.baseIndex = baseIndex;
        this.parent = parent;
    }

    @Override
    public int getDataCount() {
        return this.data.length;
    }

    @Override
    public String getFieldName(IOConsumer<String> valueCons, int ... index) {
        return "";
    }

    @Override
    public String getData(String name, int ... indexes) throws IOException {
        return this.getLocalData(name, indexes);
    }

    @Override
    public String getLocalData(String name, int ... indexes) throws IOException {
        int index = this.getIndex(indexes);
        if (index >= 0 && index < this.data.length) {
            return this.data[index];
        }
        throw new IOException();
    }

    private int getIndex(int[] indexes) {
        int index;
        if (indexes.length == 1) {
            index = this.baseIndex + indexes[0];
        } else {
            index = this.baseIndex;
            for (int i = indexes.length - 1; i >= 0; --i) {
                index += indexes[i];
            }
        }
        return index;
    }

    @Override
    public void getLocalData(IOConsumer<String> ifPresent, String name, int ... indexes) throws IOException {
        int index = this.getIndex(indexes);
        if (index >= 0 && index < this.data.length) {
            ifPresent.accept((Object)this.data[index]);
        }
    }

    @Override
    public void getData(IOConsumer<String> ifPresent, String name, int ... indexes) throws IOException {
        this.getLocalData(ifPresent, name, indexes);
    }

    public ArrayParseResult stepInto(String name, int index) {
        return new ArrayParseResult(this.data, index, this);
    }

    public ArrayParseResult stepOut() {
        return this.parent;
    }

    protected String[] getData() {
        return this.data;
    }
}

