/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.connectors.model;

import de.iip_ecosphere.platform.connectors.formatter.FormatCache;
import de.iip_ecosphere.platform.connectors.parser.InputParser;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class ModelInputConverter
implements InputParser.InputConverter<Object> {
    public static final ModelInputConverter INSTANCE = new ModelInputConverter();

    protected ModelInputConverter() {
    }

    @Override
    public int toInteger(Object data) throws IOException {
        return (Integer)data;
    }

    @Override
    public long toLong(Object data) throws IOException {
        return (Long)data;
    }

    @Override
    public short toShort(Object data) throws IOException {
        return (Short)data;
    }

    @Override
    public String toString(Object data) throws IOException {
        return null != data ? data.toString() : null;
    }

    @Override
    public double toDouble(Object data) throws IOException {
        return (Double)data;
    }

    @Override
    public float toFloat(Object data) throws IOException {
        return ((Float)data).floatValue();
    }

    @Override
    public boolean toBoolean(Object data) throws IOException {
        return (Boolean)data;
    }

    @Override
    public int[] toIntegerArray(Object data) throws IOException {
        return (int[])data;
    }

    @Override
    public double[] toDoubleArray(Object data) throws IOException {
        return (double[])data;
    }

    @Override
    public Date toDate(Object data, String format) throws IOException {
        if (data instanceof String) {
            SimpleDateFormat f = FormatCache.getDateFormatter(format);
            try {
                return f.parse((String)data);
            }
            catch (ParseException e) {
                throw new IOException(e);
            }
        }
        return (Date)data;
    }

    @Override
    public Object toObject(Object data) throws IOException {
        return data;
    }
}

