/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.connectors.formatter;

import de.iip_ecosphere.platform.connectors.formatter.ConverterToString;
import de.iip_ecosphere.platform.connectors.formatter.MachineFormatter;
import de.iip_ecosphere.platform.connectors.formatter.OutputFormatter;
import java.io.IOException;

@MachineFormatter
public class TextLineFormatter
implements OutputFormatter<String> {
    public static final TextLineFormatterConverter CONVERTER = new TextLineFormatterConverter();
    private String charset;
    private String separator;
    private StringBuilder tmp = new StringBuilder();

    public TextLineFormatter(String charset, String separator) {
        this.charset = charset;
        this.separator = separator;
    }

    @Override
    public void add(String name, String data) throws IOException {
        if (this.tmp.length() > 0) {
            this.tmp.append(this.separator);
        }
        this.tmp.append(data);
    }

    @Override
    public byte[] chunkCompleted() throws IOException {
        String result = this.tmp.toString();
        this.tmp = new StringBuilder();
        return result.getBytes(this.charset);
    }

    public TextLineFormatterConverter getConverter() {
        return CONVERTER;
    }

    public static class TextLineFormatterConverter
    extends ConverterToString {
    }
}

