/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.connectors.formatter;

import de.iip_ecosphere.platform.transport.serialization.IipEnum;
import java.io.IOException;
import java.util.Date;

public interface OutputFormatter<T> {
    public static final char SEPARATOR = '.';

    public void add(String var1, T var2) throws IOException;

    public byte[] chunkCompleted() throws IOException;

    public OutputConverter<T> getConverter();

    public static interface OutputConverter<T> {
        public T fromInteger(int var1) throws IOException;

        public T fromLong(long var1) throws IOException;

        public T fromString(String var1) throws IOException;

        public T fromShort(short var1) throws IOException;

        public T fromDouble(double var1) throws IOException;

        public T fromFloat(float var1) throws IOException;

        public T fromBoolean(boolean var1) throws IOException;

        public T fromIntegerArray(int[] var1) throws IOException;

        public T fromDoubleArray(double[] var1) throws IOException;

        public T fromDate(Date var1, String var2) throws IOException;

        default public T fromEnum(IipEnum data) throws IOException {
            return this.fromInteger(data.getModelOrdinal());
        }

        default public T fromEnumAsName(Enum<?> data) throws IOException {
            return this.fromString(data.name());
        }

        public T fromObject(Object var1) throws IOException;
    }
}

