/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.connectors.formatter;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.iip_ecosphere.platform.connectors.formatter.FormatCache;
import de.iip_ecosphere.platform.connectors.formatter.MachineFormatter;
import de.iip_ecosphere.platform.connectors.formatter.OutputFormatter;
import de.iip_ecosphere.platform.support.function.IOConsumer;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;

@MachineFormatter
public class JsonOutputFormatter
implements OutputFormatter<IOConsumer<JsonGenerator>> {
    private ObjectMapper objectMapper = new ObjectMapper();
    private StringWriter writer;
    private JsonGenerator gen;
    private String parentName = "";

    private void cleanNesting(String parent) throws IOException {
        while (this.parentName.length() > 0 && !parent.equals(this.parentName)) {
            this.gen.writeEndObject();
            int pos = this.parentName.lastIndexOf(46);
            if (pos > 0) {
                this.parentName = this.parentName.substring(0, pos);
                continue;
            }
            this.parentName = "";
        }
    }

    @Override
    public void add(String name, IOConsumer<JsonGenerator> func) throws IOException {
        if (null == this.gen) {
            JsonFactory f = this.objectMapper.getFactory();
            this.writer = new StringWriter();
            this.gen = f.createGenerator((Writer)this.writer);
            this.gen.writeStartObject();
        }
        String fieldName = name;
        if (name.indexOf(46) > 0) {
            int pos = name.lastIndexOf(46);
            fieldName = name.substring(pos + 1);
            String parent = name.substring(0, pos);
            this.cleanNesting(parent);
            int startPos = this.parentName.length() + 1;
            while (!this.parentName.equals(parent)) {
                pos = parent.indexOf(46, startPos);
                if (pos < 0) {
                    this.gen.writeFieldName(parent);
                    this.gen.writeStartObject();
                    this.parentName = parent;
                    break;
                }
                String pathPartName = parent.substring(startPos, pos);
                this.gen.writeFieldName(pathPartName);
                this.gen.writeStartObject();
                if (this.parentName.length() > 0) {
                    this.parentName = this.parentName + '.';
                }
                this.parentName = this.parentName + pathPartName;
            }
        } else {
            this.cleanNesting("");
            this.parentName = "";
        }
        this.gen.writeFieldName(fieldName);
        func.accept((Object)this.gen);
    }

    @Override
    public byte[] chunkCompleted() throws IOException {
        byte[] res = null;
        if (this.gen != null) {
            this.cleanNesting("");
            this.gen.writeEndObject();
            this.gen.close();
            res = this.writer.toString().getBytes();
            this.gen = null;
        }
        return res;
    }

    public JsonOutputConverter getConverter() {
        return new JsonOutputConverter();
    }

    public static class JsonOutputConverter
    implements OutputFormatter.OutputConverter<IOConsumer<JsonGenerator>> {
        @Override
        public IOConsumer<JsonGenerator> fromInteger(int data) throws IOException {
            return g -> g.writeNumber(data);
        }

        @Override
        public IOConsumer<JsonGenerator> fromLong(long data) throws IOException {
            return g -> g.writeNumber(data);
        }

        @Override
        public IOConsumer<JsonGenerator> fromString(String data) throws IOException {
            return g -> g.writeString(data);
        }

        @Override
        public IOConsumer<JsonGenerator> fromShort(short data) throws IOException {
            return g -> g.writeNumber(data);
        }

        @Override
        public IOConsumer<JsonGenerator> fromDouble(double data) throws IOException {
            return g -> g.writeNumber(data);
        }

        @Override
        public IOConsumer<JsonGenerator> fromFloat(float data) throws IOException {
            return g -> g.writeNumber(data);
        }

        @Override
        public IOConsumer<JsonGenerator> fromBoolean(boolean data) throws IOException {
            return g -> g.writeBoolean(data);
        }

        @Override
        public IOConsumer<JsonGenerator> fromIntegerArray(int[] data) throws IOException {
            return g -> g.writeArray(data, 0, data.length);
        }

        @Override
        public IOConsumer<JsonGenerator> fromDoubleArray(double[] data) throws IOException {
            return g -> g.writeArray(data, 0, data.length);
        }

        @Override
        public IOConsumer<JsonGenerator> fromObject(Object data) throws IOException {
            return g -> g.writeObject(data);
        }

        @Override
        public IOConsumer<JsonGenerator> fromDate(Date data, String format) throws IOException {
            return g -> {
                SimpleDateFormat f = FormatCache.getDateFormatter(format);
                g.writeString(f.format(data));
            };
        }
    }
}

