/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.connectors;

import de.iip_ecosphere.platform.connectors.AbstractConnector;
import de.iip_ecosphere.platform.connectors.ChannelAdapterSelector;
import de.iip_ecosphere.platform.connectors.types.ChannelProtocolAdapter;
import de.iip_ecosphere.platform.connectors.types.ProtocolAdapter;
import java.io.IOException;

public abstract class AbstractChannelConnector<O, I, CO, CI>
extends AbstractConnector<O, I, CO, CI> {
    private String[] outputChannels;
    private ChannelAdapterSelector<O, I, CO, CI> selector = (ChannelAdapterSelector)super.getSelector();

    @SafeVarargs
    protected AbstractChannelConnector(ChannelProtocolAdapter<O, I, CO, CI> ... adapter) {
        this((ChannelAdapterSelector<O, I, CO, CI>)null, adapter);
    }

    @SafeVarargs
    protected AbstractChannelConnector(ChannelAdapterSelector<O, I, CO, CI> selector, ChannelProtocolAdapter<O, I, CO, CI> ... adapter) {
        super(AbstractChannelConnector.ensureAdapterSelector(selector, adapter), adapter);
        this.outputChannels = new String[adapter.length];
        for (int a = 0; a < adapter.length; ++a) {
            this.outputChannels[a] = adapter[a].getOutputChannel();
        }
    }

    private static <O, I, CO, CI> ChannelAdapterSelector<O, I, CO, CI> ensureAdapterSelector(ChannelAdapterSelector<O, I, CO, CI> selector, final ChannelProtocolAdapter<O, I, CO, CI>[] adapter) {
        ChannelAdapterSelector result = selector;
        if (null == result) {
            result = new ChannelAdapterSelector<O, I, CO, CI>(){

                @Override
                public ChannelProtocolAdapter<O, I, CO, CI> selectSouthOutput(O data) {
                    return adapter[0];
                }

                @Override
                public ChannelProtocolAdapter<O, I, CO, CI> selectNorthInput(CI data) {
                    return adapter[0];
                }
            };
        }
        return result;
    }

    @Override
    protected ChannelAdapterSelector<O, I, CO, CI> getSelector() {
        return this.selector;
    }

    @Override
    public void write(CI data) throws IOException {
        ProtocolAdapter adapter = this.selector.selectNorthInput((Object)data);
        this.writeImpl(adapter.adaptInput(data), adapter.getInputChannel());
    }

    @Override
    protected final void writeImpl(I data) throws IOException {
    }

    protected abstract void writeImpl(I var1, String var2) throws IOException;

    protected String[] getOutputChannels() {
        return (String[])this.outputChannels.clone();
    }
}

