/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.connectors;

import de.iip_ecosphere.platform.connectors.parser.InputParser;
import de.iip_ecosphere.platform.connectors.parser.ParserUtils;
import de.iip_ecosphere.platform.connectors.parser.TextLineParser;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.junit.Assert;
import org.junit.Test;
import test.de.iip_ecosphere.platform.connectors.MyEnum;

public class TextLineParserTest {
    @Test
    public void testTextLineParser() throws IOException {
        String charset = StandardCharsets.UTF_8.name();
        String[] parts = new String[]{"123", "bbb", "true", "0.45", "0.56", "12345", "20", "TEST1"};
        this.testTextLineParser(parts, charset, "#");
        TextLineParser.TextLineParseResult pr = this.testTextLineParser(parts, charset, "#-#");
        Assert.assertEquals((Object)"", (Object)pr.getFieldName(new int[0]));
        TextLineParser.TextLineParserConverter conv = TextLineParser.CONVERTER;
        Assert.assertEquals((Object)parts[0], (Object)conv.toString(pr.getData("fieldX", new int[]{0})));
        Assert.assertEquals((Object)parts[1], (Object)conv.toString(pr.getData("field2", new int[]{1})));
        Assert.assertEquals((Object)parts[1], (Object)conv.toString(pr.getLocalData("field2", new int[]{1})));
        pr.getData(d -> Assert.assertEquals((Object)parts[1], (Object)conv.toString(d)), "field2", new int[]{1});
        pr.getLocalData(d -> Assert.assertEquals((Object)parts[1], (Object)conv.toString(d)), "field2", new int[]{1});
        Assert.assertEquals((Object)parts[1], (Object)conv.toString(pr.getData("f", new int[]{1})));
        Assert.assertEquals((double)0.45, (double)conv.toDouble(pr.getData("f", new int[]{1, 2})), (double)0.01);
        Assert.assertEquals((double)0.56, (double)conv.toDouble(pr.getData("", new int[]{4})), (double)0.01);
        Assert.assertEquals((long)12345L, (long)conv.toInteger(pr.getData("", new int[]{5})));
        Assert.assertEquals((Object)((Object)MyEnum.TEST2), (Object)conv.toEnum((Object)pr.getData("", new int[]{6}), MyEnum.class));
        Assert.assertEquals((Object)((Object)MyEnum.TEST1), (Object)conv.toEnum((Object)pr.getData("", new int[]{7}), MyEnum.class));
        Assert.assertEquals((Object)((Object)MyEnum.TEST1), (Object)conv.toEnum((Object)pr.getLocalData("", new int[]{7}), MyEnum.class));
        try {
            pr.getData("f", new int[]{10});
            Assert.fail((String)"No Exception");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        pr.getData(d -> Assert.fail(), "f", new int[]{10});
        pr.getLocalData(d -> Assert.fail(), "f", new int[]{10});
        charset = StandardCharsets.ISO_8859_1.name();
        this.testTextLineParser(parts, charset, "#");
        this.testTextLineParser(parts, charset, "#-#");
        pr = pr.stepInto("x", 1);
        Assert.assertEquals((Object)parts[1], (Object)conv.toString(pr.getData("field2", new int[]{0})));
        Assert.assertEquals((double)0.45, (double)conv.toDouble(pr.getData("f", new int[]{2})), (double)0.01);
        pr = pr.stepOut();
        Assert.assertEquals((Object)parts[0], (Object)conv.toString(pr.getData("fieldX", new int[]{0})));
    }

    private TextLineParser.TextLineParseResult testTextLineParser(String[] parts, String charset, String separator) throws IOException {
        String testString = "";
        for (String p : parts) {
            if (testString.length() > 0) {
                testString = testString + separator;
            }
            testString = testString + p;
        }
        TextLineParser parser = new TextLineParser(charset, separator);
        Assert.assertNotNull((Object)parser.getConverter());
        TextLineParser.TextLineParseResult result = parser.parse(testString.getBytes(charset));
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)parts.length, (long)result.getDataCount());
        return result;
    }

    @Test
    public void testConverterFail() {
        TextLineParser.TextLineParserConverter conv = TextLineParser.CONVERTER;
        try {
            conv.toInteger("abba");
            Assert.fail((String)"No exception thrown");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            conv.toFloat("abba");
            Assert.fail((String)"No exception thrown");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            conv.toLong("abba");
            Assert.fail((String)"No exception thrown");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            conv.toDouble("abba");
            Assert.fail((String)"No exception thrown");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testCreateInstance() {
        ClassLoader loader = TextLineParserTest.class.getClassLoader();
        Assert.assertNull((Object)ParserUtils.createInstance((ClassLoader)loader, (String)"me.here.Parser", (String)"UTF-8"));
        Assert.assertNotNull((Object)ParserUtils.createInstance((ClassLoader)loader, (String)CustomBaseParser.class.getName(), (String)"UTF-8"));
        InputParser p = ParserUtils.createInstance((ClassLoader)loader, (String)CustomExBaseParser.class.getName(), (String)"UTF-8");
        Assert.assertTrue((boolean)(p instanceof CustomExBaseParser));
        Assert.assertEquals((Object)"UTF-8", (Object)((CustomExBaseParser)p).getEncoding());
    }

    public static class CustomExBaseParser
    extends CustomBaseParser {
        private String encoding;

        public CustomExBaseParser(String encoding) {
            this.encoding = encoding;
        }

        public String getEncoding() {
            return this.encoding;
        }
    }

    public static class CustomBaseParser
    implements InputParser<String> {
        public InputParser.ParseResult<String> parse(byte[] data) throws IOException {
            return null;
        }

        public InputParser.InputConverter<String> getConverter() {
            return null;
        }
    }
}

