/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.connectors;

import de.iip_ecosphere.platform.connectors.model.ModelAccess;
import de.iip_ecosphere.platform.connectors.types.AbstractConnectorInputTypeTranslator;
import java.io.IOException;
import org.junit.Assert;
import test.de.iip_ecosphere.platform.connectors.MachineCommand;

public class MachineCommandInputTranslator<O>
extends AbstractConnectorInputTypeTranslator<MachineCommand, O> {
    private Class<? extends O> sourceType;
    private InputCustomizer customizer;

    public MachineCommandInputTranslator(Class<? extends O> sourceType, InputCustomizer customizer) {
        this.sourceType = sourceType;
        this.customizer = customizer;
    }

    public O from(MachineCommand data) throws IOException {
        ModelAccess access = this.getModelAccess();
        if (data.isStart()) {
            access.call(this.customizer.getQNameOperationStartMachine(), new Object[0]);
        }
        if (data.isStop()) {
            access.call(this.customizer.getQNameOperationStopMachine(), new Object[0]);
        }
        if (data.getLotSize() > 0) {
            access.set(this.customizer.getQNameVarLotSize(), access.getOutputConverter().fromInteger(data.getLotSize()));
        }
        this.customizer.additionalFromActions(access, data);
        try {
            access.set(this.customizer.getTopLevelModelPartName() + access.getQSeparator() + "abxy", (Object)"");
            Assert.fail((String)"Property shall not exist");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            access.call(this.customizer.getTopLevelModelPartName() + access.getQSeparator() + "abxy", new Object[0]);
            Assert.fail((String)"Operation shall not exist");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            access.call("abc" + access.getQSeparator() + "abxy", new Object[0]);
            Assert.fail((String)"Operation shall not exist");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            access.call("abxy", new Object[0]);
            Assert.fail((String)"Operation shall not exist");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public Class<? extends O> getSourceType() {
        return this.sourceType;
    }

    public Class<? extends MachineCommand> getTargetType() {
        return MachineCommand.class;
    }

    public static interface InputCustomizer {
        public String getQNameOperationStartMachine();

        public String getQNameOperationStopMachine();

        public String getQNameVarLotSize();

        public String getTopLevelModelPartName();

        public void additionalFromActions(ModelAccess var1, MachineCommand var2) throws IOException;
    }
}

