/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.connectors;

import de.iip_ecosphere.platform.connectors.formatter.JsonOutputFormatter;
import de.iip_ecosphere.platform.connectors.parser.JsonInputParser;
import de.iip_ecosphere.platform.support.function.IOConsumer;
import de.iip_ecosphere.platform.transport.serialization.IipEnum;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import org.junit.Assert;
import org.junit.Test;
import test.de.iip_ecosphere.platform.connectors.MyEnum;

public class JsonOutputFormatterTest {
    @Test
    public void testFormatter() throws IOException {
        String iec61131u3DateTime = "'DT#'yyyy-MM-dd-HH:mm:ss.SS";
        JsonOutputFormatter formatter = new JsonOutputFormatter();
        JsonOutputFormatter.JsonOutputConverter fConv = formatter.getConverter();
        formatter.add("field", fConv.fromInteger(10));
        formatter.add("nest.name", fConv.fromString("abba"));
        formatter.add("nest.value", fConv.fromDouble(1.234));
        formatter.add("fieldX", fConv.fromInteger(20));
        formatter.add("enum", (IOConsumer)fConv.fromEnum((IipEnum)MyEnum.TEST2));
        formatter.add("enumName", (IOConsumer)fConv.fromEnumAsName((Enum)MyEnum.TEST1));
        Date now = Calendar.getInstance().getTime();
        formatter.add("time", fConv.fromDate(now, "'DT#'yyyy-MM-dd-HH:mm:ss.SS"));
        byte[] chunk = formatter.chunkCompleted();
        String tmp = new String(chunk);
        System.out.println("OUT " + tmp);
        JsonInputParser parser = new JsonInputParser();
        JsonInputParser.JsonInputConverter pConv = parser.getConverter();
        JsonInputParser.JsonParseResult pr = parser.parse(chunk);
        Assert.assertEquals((long)10L, (long)pConv.toInteger(pr.getData("field", new int[]{0})));
        Assert.assertEquals((Object)"abba", (Object)pConv.toString(pr.getData("nest.name", new int[0])));
        Assert.assertEquals((double)1.234, (double)pConv.toDouble(pr.getData("nest.value", new int[]{0})), (double)0.01);
        Assert.assertEquals((double)1.234, (double)pConv.toDouble(pr.getData("", new int[]{1, 1})), (double)0.01);
        Assert.assertEquals((long)20L, (long)pConv.toInteger(pr.getData("fieldX", new int[]{0})));
        Assert.assertEquals((Object)now, (Object)pConv.toDate(pr.getData("time", new int[]{0}), "'DT#'yyyy-MM-dd-HH:mm:ss.SS"));
        Assert.assertEquals((Object)((Object)MyEnum.TEST2), (Object)pConv.toEnum((Object)pr.getData("enum", new int[]{0}), MyEnum.class));
        Assert.assertEquals((Object)((Object)MyEnum.TEST1), (Object)pConv.toEnum((Object)pr.getData("enumName", new int[]{0}), MyEnum.class));
    }
}

