/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.connectors;

import de.iip_ecosphere.platform.connectors.parser.JsonInputParser;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;
import test.de.iip_ecosphere.platform.connectors.MyEnum;

public class JsonInputParserTest {
    @Test
    public void testJsonInputParser() throws IOException {
        JsonInputParser parser = new JsonInputParser();
        String data = "{\"name\": \"abc\", \"value\": 1, \"enum\":20, \"enumName\":\"TEST1\"}";
        JsonInputParser.JsonParseResult res = parser.parse(data.getBytes());
        JsonInputParser.JsonInputConverter conv = parser.getConverter();
        Assert.assertEquals((Object)"abc", (Object)conv.toString(res.getData("name", new int[]{0})));
        Assert.assertEquals((Object)"abc", (Object)conv.toString(res.getLocalData("name", new int[]{0})));
        Assert.assertEquals((long)1L, (long)conv.toInteger(res.getData("value", new int[]{0})));
        Assert.assertEquals((Object)((Object)MyEnum.TEST2), (Object)conv.toEnum((Object)res.getData("enum", new int[]{2}), MyEnum.class));
        Assert.assertEquals((Object)((Object)MyEnum.TEST1), (Object)conv.toEnum((Object)res.getData("enumName", new int[]{3}), MyEnum.class));
        res.getData(v -> Assert.assertEquals((long)1L, (long)conv.toInteger(v)), "value", new int[]{0});
        res.getData(v -> Assert.fail(), "value0", new int[0]);
        res.getLocalData(v -> Assert.assertEquals((long)1L, (long)conv.toInteger(v)), "value", new int[]{0});
        res.getLocalData(v -> Assert.fail(), "value0", new int[0]);
        Assert.assertEquals((Object)"", (Object)res.getFieldName(new int[0]));
        Assert.assertEquals((Object)"name", (Object)res.getFieldName(new int[]{0}));
        Assert.assertEquals((Object)"value", (Object)res.getFieldName(new int[]{1}));
        data = "{\"obj\": {\"name\": \"abc\", \"value\": 1}}";
        res = parser.parse(data.getBytes());
        Assert.assertEquals((Object)"abc", (Object)conv.toString(res.getData("obj.name", new int[]{0})));
        Assert.assertEquals((long)1L, (long)conv.toInteger(res.getData("obj.value", new int[]{0})));
        Assert.assertEquals((long)1L, (long)conv.toInteger(res.getData("x", new int[]{0, 1})));
        Assert.assertEquals((Object)"", (Object)res.getFieldName(new int[0]));
        Assert.assertEquals((Object)"obj", (Object)res.getFieldName(new int[]{0}));
        Assert.assertEquals((Object)"name", (Object)res.getFieldName(new int[]{0, 0}));
        Assert.assertEquals((Object)"value", (Object)res.getFieldName(new int[]{0, 1}));
        Assert.assertEquals((Object)"value", (Object)res.getFieldName(v -> Assert.assertEquals((long)1L, (long)conv.toInteger(v)), new int[]{0, 1}));
        res = res.stepInto("obj", 0);
        Assert.assertEquals((Object)"abc", (Object)conv.toString(res.getData("name", new int[]{0})));
        Assert.assertEquals((Object)"abc", (Object)conv.toString(res.getLocalData("name", new int[]{0})));
        res.getLocalData(d -> Assert.assertEquals((Object)"abc", (Object)conv.toString(d)), "name", new int[]{0});
        Assert.assertEquals((long)1L, (long)conv.toInteger(res.getData("value", new int[]{0})));
        Assert.assertEquals((long)1L, (long)conv.toInteger(res.getData("x", new int[]{1})));
        Assert.assertEquals((Object)"name", (Object)res.getFieldName(new int[]{0}));
        Assert.assertEquals((Object)"value", (Object)res.getFieldName(new int[]{1}));
        res = res.stepOut();
        Assert.assertEquals((Object)"obj", (Object)res.getFieldName(new int[]{0}));
    }
}

