/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.connectors.ads;

import de.iip_ecosphere.platform.connectors.AbstractConnector;
import de.iip_ecosphere.platform.connectors.AdapterSelector;
import de.iip_ecosphere.platform.connectors.ConnectorDescriptor;
import de.iip_ecosphere.platform.connectors.ConnectorParameter;
import de.iip_ecosphere.platform.connectors.MachineConnector;
import de.iip_ecosphere.platform.connectors.model.AbstractModelAccess;
import de.iip_ecosphere.platform.connectors.model.ModelAccess;
import de.iip_ecosphere.platform.connectors.types.ProtocolAdapter;
import de.iip_ecosphere.platform.libs.ads.AdsCommunication;
import de.iip_ecosphere.platform.libs.ads.MemorySizeCalcs;
import de.iip_ecosphere.platform.libs.ads.MemorySizeCalculator;
import de.iip_ecosphere.platform.libs.ads.ReadVisitor;
import de.iip_ecosphere.platform.libs.ads.ReadVisitorsArrays;
import de.iip_ecosphere.platform.libs.ads.WriteVisitor;
import de.iip_ecosphere.platform.libs.ads.WriteVisitorsArrays;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MachineConnector(hasModel=true, supportsModelStructs=true, supportsEvents=false, requiresTypedAccess=true, supportsModelCalls=false)
public class AdsConnector<CO, CI>
extends AbstractConnector<Object, Object, CO, CI> {
    public static final String NAME = "Generic ADS connector";
    private static final Logger LOGGER = LoggerFactory.getLogger(AdsConnector.class);
    private static final Object DUMMY = new Object();
    private static final Map<Class<?>, TypeDescriptor<?>> TYPE_DESCRIPTORS = new HashMap();
    private ConnectorParameter params;
    private AdsCommunication comm;

    @SafeVarargs
    public AdsConnector(ProtocolAdapter<Object, Object, CO, CI> ... adapter) {
        this((AdapterSelector<Object, Object, CO, CI>)null, adapter);
    }

    @SafeVarargs
    public AdsConnector(AdapterSelector<Object, Object, CO, CI> selector, ProtocolAdapter<Object, Object, CO, CI> ... adapter) {
        super(selector, adapter);
        this.configureModelAccess((ModelAccess)new AdsModelAccess());
    }

    public static <T> void registerType(Class<T> cls, MemorySizeCalculator<T> sizeCalculator, ReadVisitor.ReadVisitorSupplier<T> reader, WriteVisitor.WriteVisitorSupplier<T> writer, InstanceCreator<T> creator) {
        TYPE_DESCRIPTORS.put(cls, new TypeDescriptor<T>(sizeCalculator, reader, writer, creator));
    }

    protected void connectImpl(ConnectorParameter params) throws IOException {
        if (null == this.comm) {
            this.params = params;
            this.comm = new AdsCommunication(params.getHost(), params.getPort());
            LOGGER.info("Initializing ADS communication with {}:{}", (Object)params.getHost(), (Object)params.getPort());
            this.comm.initCommunication();
            LOGGER.info("ADS communication with {}:{} initialized ", (Object)params.getHost(), (Object)params.getPort());
        }
    }

    protected void disconnectImpl() throws IOException {
        if (this.comm != null) {
            this.comm.close();
            this.comm = null;
        }
    }

    public void dispose() {
    }

    public String getName() {
        return NAME;
    }

    protected void writeImpl(Object data) throws IOException {
    }

    protected Object read() throws IOException {
        return DUMMY;
    }

    protected void error(String message, Throwable th) {
        LOGGER.error(message + ": " + th.getMessage());
    }

    public String supportedEncryption() {
        return null;
    }

    public String enabledEncryption() {
        return null;
    }

    static {
        AdsConnector.registerType(double[].class, MemorySizeCalcs.getSizeCalculatorDoubleArray(), ReadVisitorsArrays.getReaderDouble(), WriteVisitorsArrays.getWriteSupplierLReal(), double[]::new);
        AdsConnector.registerType(float[].class, MemorySizeCalcs.getSizeCalculatorFloatArray(), ReadVisitorsArrays.getReaderFloat(), WriteVisitorsArrays.getWriteSupplierReal(), float[]::new);
        AdsConnector.registerType(int[].class, MemorySizeCalcs.getSizeCalculatorIntArray(), ReadVisitorsArrays.getReaderDIntArray(), WriteVisitorsArrays.getWriteSupplierDInt(), int[]::new);
        AdsConnector.registerType(long[].class, MemorySizeCalcs.getSizeCalculatorLongArray(), ReadVisitorsArrays.getReaderLIntArray(), WriteVisitorsArrays.getWriteSupplierLInt(), long[]::new);
        AdsConnector.registerType(short[].class, MemorySizeCalcs.getSizeCalculatorShortArray(), ReadVisitorsArrays.getReaderIntArray(), WriteVisitorsArrays.getWriteSupplierInt(), short[]::new);
        AdsConnector.registerType(byte[].class, MemorySizeCalcs.getSizeCalculatorSIntArray(), ReadVisitorsArrays.getReaderSIntArray(), WriteVisitorsArrays.getWriteSupplierSInt(), byte[]::new);
    }

    private class AdsModelAccess
    extends AbstractModelAccess {
        private static final String SEPARATOR_STRING = "/";
        private String basePath;
        private AdsModelAccess parent;

        protected AdsModelAccess() {
            super((AbstractModelAccess.NotificationChangedListener)AdsConnector.this);
            this.basePath = "";
        }

        protected AdsModelAccess(String basePath, AdsModelAccess parent) {
            this();
            this.basePath = basePath;
            this.parent = parent;
        }

        public String topInstancesQName() {
            return "";
        }

        public String getQSeparator() {
            return SEPARATOR_STRING;
        }

        public Object call(String qName, Object ... args) throws IOException {
            throw new IOException("Not implemented " + qName);
        }

        public Object get(String qName) throws IOException {
            throw new IOException("Shall not be called");
        }

        public int getInt(String qName) throws IOException {
            return AdsConnector.this.comm.readDIntByName(this.basePath + qName);
        }

        public float getFloat(String qName) throws IOException {
            return AdsConnector.this.comm.readRealByName(this.basePath + qName);
        }

        public double getDouble(String qName) throws IOException {
            return AdsConnector.this.comm.readLRealByName(this.basePath + qName);
        }

        public long getLong(String qName) throws IOException {
            return AdsConnector.this.comm.readLIntByName(this.basePath + qName);
        }

        public short getShort(String qName) throws IOException {
            return AdsConnector.this.comm.readIntByName(this.basePath + qName);
        }

        public byte getByte(String qName) throws IOException {
            return AdsConnector.this.comm.readSIntByName(this.basePath + qName);
        }

        public String getString(String qName) throws IOException {
            return AdsConnector.this.comm.readStringByName(this.basePath + qName);
        }

        public void set(String qName, Object value) throws IOException {
            AdsConnector.this.comm.writeObjectByName(this.basePath + qName, value);
        }

        public void setInt(String qName, int value) throws IOException {
            AdsConnector.this.comm.writeDIntByName(this.basePath + qName, value);
        }

        public void setLong(String qName, long value) throws IOException {
            AdsConnector.this.comm.writeLIntByName(this.basePath + qName, value);
        }

        public void setByte(String qName, byte value) throws IOException {
            AdsConnector.this.comm.writeSIntByName(this.basePath + qName, value);
        }

        public void setShort(String qName, short value) throws IOException {
            AdsConnector.this.comm.writeIntByName(this.basePath + qName, value);
        }

        public void setDouble(String qName, double value) throws IOException {
            AdsConnector.this.comm.writeLRealByName(this.basePath + qName, value);
        }

        public void setFloat(String qName, float value) throws IOException {
            AdsConnector.this.comm.writeRealByName(this.basePath + qName, value);
        }

        public void setString(String qName, String value) throws IOException {
            AdsConnector.this.comm.writeStringByName(this.basePath + qName, value);
        }

        public <T> T getStruct(String qName, Class<T> type) throws IOException {
            TypeDescriptor<?> desc = TYPE_DESCRIPTORS.get(type);
            if (null != desc) {
                return (T)desc.read(AdsConnector.this.comm, qName, 0);
            }
            try {
                T result = type.getConstructor(new Class[0]).newInstance(new Object[0]);
                AdsConnector.this.comm.readObjectByName(this.basePath + qName, result);
                return result;
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new IOException(e);
            }
        }

        public void setStruct(String qName, Object value) throws IOException {
            TypeDescriptor<?> desc = TYPE_DESCRIPTORS.get(value.getClass());
            if (null != desc) {
                desc.write(AdsConnector.this.comm, qName, value);
            } else {
                AdsConnector.this.comm.writeObjectByName(this.basePath + qName, value);
            }
        }

        public void registerCustomType(Class<?> cls) throws IOException {
        }

        public void monitor(int notificationInterval, String ... qName) throws IOException {
            throw new IOException("Event-based monitoring is not supported. Please use polling.");
        }

        public void monitorModelChanges(int notificationInterval) throws IOException {
            throw new IOException("Event-based monitoring is not supported. Please use polling.");
        }

        protected ConnectorParameter getConnectorParameter() {
            return AdsConnector.this.params;
        }

        public AdsModelAccess stepInto(String name) throws IOException {
            Object n = this.basePath;
            n = ((String)n).length() == 0 ? name : (String)n + SEPARATOR_STRING + name;
            return new AdsModelAccess((String)n, this);
        }

        public AdsModelAccess stepOut() {
            return this.parent;
        }
    }

    public static class Descriptor
    implements ConnectorDescriptor {
        public String getName() {
            return AdsConnector.NAME;
        }

        public Class<?> getType() {
            return AdsConnector.class;
        }
    }

    private static class TypeDescriptor<T> {
        private MemorySizeCalculator<T> sizeCalculator;
        private ReadVisitor.ReadVisitorSupplier<T> reader;
        private WriteVisitor.WriteVisitorSupplier<T> writer;
        private InstanceCreator<T> creator;

        private TypeDescriptor(MemorySizeCalculator<T> sizeCalculator, ReadVisitor.ReadVisitorSupplier<T> reader, WriteVisitor.WriteVisitorSupplier<T> writer, InstanceCreator<T> creator) {
            this.sizeCalculator = sizeCalculator;
            this.reader = reader;
            this.writer = writer;
            this.creator = creator;
        }

        private void write(AdsCommunication comm, String name, Object value) throws IOException {
            try {
                comm.writeStructByName(name, value, this.sizeCalculator, this.writer);
            }
            catch (ClassCastException e) {
                throw new IOException(e);
            }
        }

        private T read(AdsCommunication comm, String name, int size) throws IOException {
            T value = this.creator.create(size);
            comm.readStructByNameSimple(name, this.creator.create(0), this.sizeCalculator, this.reader);
            return value;
        }
    }

    public static interface InstanceCreator<T> {
        public T create(int var1);
    }
}

