/*
 * Decompiled with CFR 0.152.
 */
package iip.impl;

import de.iip_ecosphere.platform.services.environment.DataIngestor;
import de.iip_ecosphere.platform.services.environment.DefaultServiceImpl;
import de.iip_ecosphere.platform.services.environment.ParameterConfigurer;
import de.iip_ecosphere.platform.services.environment.ServiceKind;
import de.iip_ecosphere.platform.services.environment.YamlService;
import iip.datatypes.Rec1;
import iip.interfaces.SimpleDataSourceInterface;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class SimpleDataSourceImpl
extends DefaultServiceImpl
implements SimpleDataSourceInterface {
    private Map<String, ParameterConfigurer<?>> paramConfigurers = new HashMap();
    private List<DataIngestor<Rec1>> rec1Ingestors = new ArrayList<DataIngestor<Rec1>>();

    protected SimpleDataSourceImpl(ServiceKind kind) {
        super(kind);
        this.registerParameterConfigurers();
    }

    protected SimpleDataSourceImpl(String id, ServiceKind kind) {
        super(id, kind);
        this.registerParameterConfigurers();
    }

    protected SimpleDataSourceImpl(YamlService yaml) {
        super(yaml);
        this.registerParameterConfigurers();
    }

    protected SimpleDataSourceImpl(String serviceId, InputStream ymlFile) {
        super(serviceId, ymlFile);
        this.registerParameterConfigurers();
    }

    public ParameterConfigurer<?> getParameterConfigurer(String paramName) {
        return this.paramConfigurers.get(paramName);
    }

    protected void registerParameterConfigurers() {
    }

    @Override
    public void attachRec1Ingestor(DataIngestor<Rec1> ingestor) {
        if (ingestor != null) {
            this.rec1Ingestors.add(ingestor);
        }
    }

    protected boolean hasRec1Ingestor() {
        return this.rec1Ingestors.size() > 0;
    }

    protected int hasRec1IngestorCount() {
        return this.rec1Ingestors.size();
    }

    protected void ingestRec1(Rec1 data) {
        for (int i = 0; i < this.rec1Ingestors.size(); ++i) {
            this.rec1Ingestors.get(i).ingest((Object)data);
        }
    }
}

