package iip.impl;

import java.util.*;
import java.util.concurrent.ExecutionException;
import java.io.InputStream;
import de.iip_ecosphere.platform.transport.serialization.TypeTranslators;
import de.iip_ecosphere.platform.services.environment.*;
import iip.datatypes.*;
import iip.interfaces.*;

/**
 * IIP-Ecosphere supporting service implementation for 'Simple Data Source'.
 * Generated by: EASy-Producer.
 */
public abstract class SimpleDataSourceImpl extends DefaultServiceImpl implements SimpleDataSourceInterface {
    private Map<String, ParameterConfigurer<?>> paramConfigurers = new HashMap<>();
    private List<DataIngestor<Rec1>> rec1Ingestors = new ArrayList<>();

    /**
     * Fallback constructor setting most fields to "empty" default values.
     * 
     * @param kind the service kind
     */
    protected SimpleDataSourceImpl(ServiceKind kind) {
        super(kind);
        registerParameterConfigurers();
    }

    /**
     * Fallback constructor setting most fields to "empty" default values.
     * 
     * @param id the id of the service
     * @param kind the service kind
     */
    protected SimpleDataSourceImpl(String id, ServiceKind kind) {
        super(id, kind);
        registerParameterConfigurers();
    }

    /**
    * Creates a service instance from YAML information.
    * 
    * @param yaml the service information as read from YAML
    */
    protected SimpleDataSourceImpl(YamlService yaml) {
        super(yaml);
        registerParameterConfigurers();
    }
    
    /**
    * Creates a service instance from a service id and a YAML artifact.
    * 
    * @param serviceId the service id
    * @param ymlFile the YML file containing the YAML artifact with the service descriptor
    */
    protected SimpleDataSourceImpl(String serviceId, InputStream ymlFile) {
        super(serviceId, ymlFile);
        registerParameterConfigurers();
    }
    
    @Override
    public ParameterConfigurer<?> getParameterConfigurer(String paramName) {
        return paramConfigurers.get(paramName);
    }
    
    /**
    * Registers the configurers.
    */
    protected void registerParameterConfigurers() {            }
            
    @Override
    public void attachRec1Ingestor(DataIngestor<Rec1> ingestor) {
        if (ingestor != null) {
            rec1Ingestors.add(ingestor);
        }
    }
    
    /**
    * Returns whether there are registered Rec1 ingestors.
    *
    * @return {@code true} if there are Rec1 ingestors, {@code false} else
    */
    protected boolean hasRec1Ingestor() {
        return rec1Ingestors.size() > 0;
    }
    
    /**
    * Returns the number of registered Rec1 ingestors.
    *
    * @return the number of Rec1 ingestors
    */
    protected int hasRec1IngestorCount() {
        return rec1Ingestors.size();
    }
    
    /**
    * Sends {@code data} to all registered Rec1 ingestors.
    *
    * @param data the data to be sent
    */
    protected void ingestRec1(Rec1 data) {
        for (int i = 0; i < rec1Ingestors.size(); i++) {
            rec1Ingestors.get(i).ingest(data);
        }
    }
    
    
}
