/*
 * Decompiled with CFR 0.152.
 */
package de.ihrigb.fwla.mail;

import de.ihrigb.fwla.mail.EmailBodyConverter;
import de.ihrigb.fwla.mail.EmailBodyConvertionException;
import java.io.IOException;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.internet.MimeMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextEmailBodyConverter
implements EmailBodyConverter<String> {
    private static final Logger log = LoggerFactory.getLogger(TextEmailBodyConverter.class);

    @Override
    public String convert(MimeMessage mimeMessage) {
        try {
            return this.getText((Part)mimeMessage);
        }
        catch (IOException | MessagingException e) {
            log.error("Convertion failed.", e);
            throw new EmailBodyConvertionException("Convertion failed.", e);
        }
    }

    private String getText(Part p) throws MessagingException, IOException {
        if (p.isMimeType("text/*")) {
            Object content = p.getContent();
            return content == null ? null : content.toString();
        }
        if (p.isMimeType("multipart/alternative")) {
            Multipart mp = (Multipart)p.getContent();
            String text = null;
            for (int i = 0; i < mp.getCount(); ++i) {
                BodyPart bp = mp.getBodyPart(i);
                if (bp.isMimeType("text/plain")) {
                    if (text != null) continue;
                    text = this.getText((Part)bp);
                    continue;
                }
                if (bp.isMimeType("text/html")) {
                    String s = this.getText((Part)bp);
                    if (s == null) continue;
                    return s;
                }
                return this.getText((Part)bp);
            }
            return text;
        }
        if (p.isMimeType("multipart/*")) {
            Multipart mp = (Multipart)p.getContent();
            for (int i = 0; i < mp.getCount(); ++i) {
                String s = this.getText((Part)mp.getBodyPart(i));
                if (s == null) continue;
                return s;
            }
        }
        return null;
    }
}

