/*
 * Decompiled with CFR 0.152.
 */
package de.ihrigb.fwla.mail;

import de.ihrigb.fwla.mail.Email;
import de.ihrigb.fwla.mail.EmailBodyConverter;
import de.ihrigb.fwla.mail.EmailBodyConvertionException;
import de.ihrigb.fwla.mail.EmailHandler;
import de.ihrigb.fwla.mail.EmailSenderFilter;
import java.time.Instant;
import java.util.Optional;
import javax.mail.Address;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHandler;
import org.springframework.messaging.MessagingException;
import org.springframework.util.Assert;

public class ReceivingMessageHandler<T>
implements MessageHandler {
    private static final Logger log = LoggerFactory.getLogger(ReceivingMessageHandler.class);
    private final Optional<EmailSenderFilter> emailSenderFilter;
    private final EmailBodyConverter<T> emailBodyConverter;
    private final EmailHandler<T> emailHandler;

    public ReceivingMessageHandler(EmailBodyConverter<T> emailBodyConverter, EmailHandler<T> emailHandler) {
        this(Optional.empty(), emailBodyConverter, emailHandler);
    }

    public ReceivingMessageHandler(Optional<EmailSenderFilter> emailSenderFilter, EmailBodyConverter<T> emailBodyConverter, EmailHandler<T> emailHandler) {
        Assert.notNull(emailSenderFilter, (String)"emailSenderFilter must not be null.");
        Assert.notNull(emailBodyConverter, (String)"emailBodyConverter must not be null.");
        Assert.notNull(emailHandler, (String)"emailHandler must not be null.");
        this.emailSenderFilter = emailSenderFilter;
        this.emailBodyConverter = emailBodyConverter;
        this.emailHandler = emailHandler;
    }

    public void handleMessage(Message<?> message) throws MessagingException {
        try {
            log.info("Handling incoming email.");
            MimeMessage mimeMessage = (MimeMessage)message.getPayload();
            Address[] addresses = mimeMessage.getFrom();
            if (addresses != null) {
                String sender = ((InternetAddress)addresses[0]).getAddress();
                switch (this.emailSenderFilter.orElse(EmailSenderFilter.ACCEPT_ALL).filter(sender)) {
                    case REJECTED: {
                        log.info("Mail from '{}' was rejected.", (Object)sender);
                        return;
                    }
                }
                log.info("Mail from '{}' was accepted.", (Object)sender);
                String subject = mimeMessage.getSubject();
                T body = this.emailBodyConverter.convert(mimeMessage);
                Instant timestamp = Instant.ofEpochMilli(message.getHeaders().getTimestamp());
                Email<T> email = new Email<T>(sender, subject, body, timestamp);
                this.emailHandler.handle(email);
            } else {
                log.warn("No sender present.");
            }
        }
        catch (EmailBodyConvertionException e) {
            log.error("Email body convertion failed.", (Throwable)e);
            throw new MessagingException("Email body convertion failed.", (Throwable)e);
        }
        catch (javax.mail.MessagingException e) {
            log.error("Generic javax.mail MessagingException.", (Throwable)e);
            throw new MessagingException("Generic javax.mail MessagingException.", (Throwable)e);
        }
    }
}

