/*
 * Decompiled with CFR 0.152.
 */
package de.holisticon.annotationprocessortoolkit.testhelper;

import com.google.common.truth.SubjectFactory;
import com.google.common.truth.Truth;
import com.google.testing.compile.CompileTester;
import com.google.testing.compile.JavaFileObjects;
import com.google.testing.compile.JavaSourceSubjectFactory;
import com.google.testing.compile.JavaSourcesSubject;
import de.holisticon.annotationprocessortoolkit.testhelper.AnnotationProcessorWrapper;
import javax.annotation.processing.Processor;
import javax.tools.JavaFileObject;

public abstract class AbstractAnnotationProcessorTest<T extends Processor> {
    public static final String TEST_EXECUTION_MESSAGE = "!!!--- TEST WAS EXECUTED ---!!!";
    private final String description;
    private final String resource;
    private final String[] errors;
    private final String[] warnings;

    public AbstractAnnotationProcessorTest(String description, String resource, String[] errors, String[] warnings) {
        this.description = description;
        this.resource = resource;
        this.errors = errors;
        this.warnings = warnings;
    }

    protected abstract Processor getAnnotationProcessor();

    private Processor getWrappedProcessor() {
        return AnnotationProcessorWrapper.wrapProcessor(this.getAnnotationProcessor());
    }

    protected void test() {
        JavaFileObject testClassSource = JavaFileObjects.forResource((String)this.resource);
        if (this.errors.length == 0) {
            CompileTester.SuccessfulCompilationClause compileTester = ((JavaSourcesSubject.SingleSourceAdapter)Truth.assertAbout((SubjectFactory)JavaSourceSubjectFactory.javaSource()).that((Object)testClassSource)).processedWith(this.getWrappedProcessor(), new Processor[0]).compilesWithoutError();
            for (String warning : this.warnings) {
                compileTester.withWarningContaining(warning);
            }
            compileTester.withNoteContaining(TEST_EXECUTION_MESSAGE);
        } else {
            CompileTester.UnsuccessfulCompilationClause compileTester = ((JavaSourcesSubject.SingleSourceAdapter)Truth.assertAbout((SubjectFactory)JavaSourceSubjectFactory.javaSource()).that((Object)testClassSource)).processedWith(this.getWrappedProcessor(), new Processor[0]).failsToCompile();
            for (String error : this.errors) {
                compileTester.withErrorContaining(error);
            }
            compileTester.withNoteContaining(TEST_EXECUTION_MESSAGE);
        }
    }
}

