/*
 * Decompiled with CFR 0.152.
 */
package de.holisticon.annotationprocessortoolkit.templating.templateblocks;

import de.holisticon.annotationprocessortoolkit.templating.expressions.Expression;
import de.holisticon.annotationprocessortoolkit.templating.expressions.ExpressionParser;
import de.holisticon.annotationprocessortoolkit.templating.expressions.operands.Operand;
import de.holisticon.annotationprocessortoolkit.templating.templateblocks.TemplateBlock;
import de.holisticon.annotationprocessortoolkit.templating.templateblocks.TemplateBlockBinder;
import de.holisticon.annotationprocessortoolkit.templating.templateblocks.TemplateBlockType;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class IfTemplateBlock
implements TemplateBlock {
    private static final Pattern ATTRIBUTE_PATTERN = Pattern.compile("(.+)");
    private final String accessPath;
    private final String templateString;
    private TemplateBlockBinder binder;

    public IfTemplateBlock(String attributeString, String templateString) {
        if (attributeString == null || attributeString.trim().isEmpty()) {
            throw new IllegalArgumentException("if command has no attribute string.");
        }
        Matcher matcher = ATTRIBUTE_PATTERN.matcher(attributeString);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("if command has an invalid attribute string.");
        }
        this.accessPath = matcher.group(1);
        this.templateString = templateString;
        this.binder = new TemplateBlockBinder(templateString);
    }

    @Override
    public TemplateBlockType getTemplateBlockType() {
        return TemplateBlockType.IF;
    }

    @Override
    public String getContent(Map<String, Object> outerVariables) {
        Expression expression = ExpressionParser.parseExpression(this.accessPath, outerVariables);
        Operand result = expression.evaluateExpression();
        if (result.value() != null && result.getOperandsJavaType().equals(Boolean.class) && ((Boolean)result.value()).booleanValue()) {
            return this.binder.getContent(outerVariables).toString();
        }
        return "";
    }

    public TemplateBlockBinder getBinder() {
        return this.binder;
    }

    public void setBinder(TemplateBlockBinder binder) {
        this.binder = binder;
    }

    public String getAccessPath() {
        return this.accessPath;
    }

    public String getTemplateString() {
        return this.templateString;
    }
}

