/*
 * Decompiled with CFR 0.152.
 */
package de.holisticon.annotationprocessortoolkit.templating.templateblocks;

import de.holisticon.annotationprocessortoolkit.templating.ModelPathResolver;
import de.holisticon.annotationprocessortoolkit.templating.templateblocks.TemplateBlock;
import de.holisticon.annotationprocessortoolkit.templating.templateblocks.TemplateBlockBinder;
import de.holisticon.annotationprocessortoolkit.templating.templateblocks.TemplateBlockType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ForTemplateBlock
implements TemplateBlock {
    private static final Pattern ATTRIBUTE_PATTERN = Pattern.compile("\\s*(\\w+?)\\s*[:]\\s*((?:\\w|[.])+?)\\s*");
    private final String loopVariableName;
    private final String accessPath;
    private final String templateString;
    private TemplateBlockBinder binder;

    public ForTemplateBlock(String attributeString, String templateString) {
        if (attributeString == null || attributeString.trim().isEmpty()) {
            throw new IllegalArgumentException("for command has no attribute string.");
        }
        Matcher matcher = ATTRIBUTE_PATTERN.matcher(attributeString);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("for command has an invalid attribute string.");
        }
        this.loopVariableName = matcher.group(1);
        this.accessPath = matcher.group(2);
        this.templateString = templateString;
        this.binder = new TemplateBlockBinder(templateString);
    }

    @Override
    public TemplateBlockType getTemplateBlockType() {
        return TemplateBlockType.FOR;
    }

    @Override
    public String getContent(Map<String, Object> outerVariables) {
        StringBuilder stringBuilder;
        block2: {
            Object values;
            HashMap<String, Object> variables;
            block3: {
                variables = new HashMap<String, Object>();
                variables.putAll(outerVariables);
                values = ModelPathResolver.resolveModelPath(outerVariables, this.accessPath).getValue();
                stringBuilder = new StringBuilder();
                if (values == null) break block2;
                if (!values.getClass().isArray()) break block3;
                for (Object value : (Object[])values) {
                    variables.put(this.loopVariableName, value);
                    stringBuilder.append(this.binder.getContent(variables));
                }
                break block2;
            }
            if (!(values instanceof List)) break block2;
            for (Object value : (List)values) {
                variables.put(this.loopVariableName, value);
                stringBuilder.append(this.binder.getContent(variables));
            }
        }
        return stringBuilder.toString();
    }

    public TemplateBlockBinder getBinder() {
        return this.binder;
    }

    public void setBinder(TemplateBlockBinder binder) {
        this.binder = binder;
    }

    public String getLoopVariableName() {
        return this.loopVariableName;
    }

    public String getAccessPath() {
        return this.accessPath;
    }

    public String getTemplateString() {
        return this.templateString;
    }
}

