/*
 * Decompiled with CFR 0.152.
 */
package de.holisticon.annotationprocessortoolkit.templating;

import de.holisticon.annotationprocessortoolkit.templating.NextDetectedBlockResult;
import de.holisticon.annotationprocessortoolkit.templating.templateblocks.ForTemplateBlock;
import de.holisticon.annotationprocessortoolkit.templating.templateblocks.IfTemplateBlock;
import de.holisticon.annotationprocessortoolkit.templating.templateblocks.PlainTextTemplateBlock;
import de.holisticon.annotationprocessortoolkit.templating.templateblocks.StaticTemplateBlock;
import de.holisticon.annotationprocessortoolkit.templating.templateblocks.TemplateBlockBinder;
import de.holisticon.annotationprocessortoolkit.templating.templateblocks.TemplateBlockType;
import de.holisticon.annotationprocessortoolkit.templating.templateblocks.VariableTextTemplateBlock;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ParseUtilities {
    public static final Pattern DYNAMIC_TEXT_BLOCK_REGEX = Pattern.compile("[$][{]\\s*((?:\\w|.)*?)\\s*[}]");

    public static TemplateBlockBinder parseString(String templateString) {
        String tmpTemplateString = templateString;
        TemplateBlockBinder binder = new TemplateBlockBinder(tmpTemplateString);
        NextDetectedBlockResult nextBlock = TemplateBlockType.getNextBlock(templateString);
        while (nextBlock != null) {
            if (nextBlock.getBeginIndex() != 0) {
                binder.addTemplateBlock(new PlainTextTemplateBlock(tmpTemplateString.substring(0, nextBlock.getBeginIndex())));
            }
            switch (nextBlock.getTemplateBlockType()) {
                case DYNAMIC_TEXT: {
                    ParserResult nextDynamicText = ParseUtilities.getNextDynamicText(tmpTemplateString);
                    binder.addTemplateBlock(new VariableTextTemplateBlock(nextDynamicText.getContent()));
                    tmpTemplateString = tmpTemplateString.substring(nextDynamicText.getEndIndex());
                    break;
                }
                case FOR: {
                    ForTemplateBlock forTemplateBlock = new ForTemplateBlock(nextBlock.getAttributes(), nextBlock.getContent());
                    binder.addTemplateBlock(forTemplateBlock);
                    forTemplateBlock.setBinder(ParseUtilities.parseString(forTemplateBlock.getTemplateString()));
                    tmpTemplateString = nextBlock.getRemainingStringToBeProcessed();
                    break;
                }
                case IF: {
                    IfTemplateBlock ifTemplateBlock = new IfTemplateBlock(nextBlock.getAttributes(), nextBlock.getContent());
                    binder.addTemplateBlock(ifTemplateBlock);
                    ifTemplateBlock.setBinder(ParseUtilities.parseString(ifTemplateBlock.getTemplateString()));
                    tmpTemplateString = nextBlock.getRemainingStringToBeProcessed();
                    break;
                }
                case STATIC: {
                    StaticTemplateBlock staticTemplateBlock = new StaticTemplateBlock(nextBlock.getContent());
                    binder.addTemplateBlock(staticTemplateBlock);
                    tmpTemplateString = nextBlock.getRemainingStringToBeProcessed();
                    break;
                }
            }
            nextBlock = TemplateBlockType.getNextBlock(tmpTemplateString);
        }
        binder.addTemplateBlock(new PlainTextTemplateBlock(tmpTemplateString));
        return binder;
    }

    protected static ParserResult getNextDynamicText(String templateString) {
        if (templateString == null) {
            return null;
        }
        Matcher matcher = DYNAMIC_TEXT_BLOCK_REGEX.matcher(templateString);
        if (matcher.find()) {
            return new ParserResult(matcher.start(), matcher.end(), matcher.group(1));
        }
        return null;
    }

    protected Integer getNextControlBlock(String templateString) {
        return null;
    }

    public static String readResourceToString(String resourcefileName) throws Exception {
        InputStream inputStream = ParseUtilities.class.getResourceAsStream(resourcefileName);
        if (inputStream != null) {
            return ParseUtilities.readFromInputStream(inputStream);
        }
        throw new IllegalArgumentException("Can't open resource file '" + resourcefileName + "'");
    }

    public static String readFromInputStream(InputStream stream) throws IOException {
        byte[] buffer = new byte[10000];
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        int line = 0;
        while ((line = stream.read(buffer)) != -1) {
            os.write(buffer, 0, line);
        }
        stream.close();
        os.flush();
        os.close();
        return new String(os.toByteArray());
    }

    private static enum NextBlockType {
        NONE,
        FOR,
        IF,
        STATIC,
        DYNAMIC_TEXT;

    }

    public static class ParserResult {
        private final int beginIndex;
        private final int endIndex;
        private final String content;

        public ParserResult(int beginIndex, int endIndex, String content) {
            this.beginIndex = beginIndex;
            this.endIndex = endIndex;
            this.content = content;
        }

        public int getBeginIndex() {
            return this.beginIndex;
        }

        public int getEndIndex() {
            return this.endIndex;
        }

        public String getContent() {
            return this.content;
        }
    }
}

