/*
 * Decompiled with CFR 0.152.
 */
package de.holisticon.annotationprocessortoolkit.templating.expressions.operands;

import de.holisticon.annotationprocessortoolkit.templating.expressions.operands.Operand;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public enum InternalOperandTypeForCalculations {
    DECIMAL(Short.class, Short.TYPE, Integer.class, Integer.TYPE, Long.class, Long.TYPE),
    FLOAT(Float.class, Float.TYPE, Double.class, Double.TYPE),
    BOOLEAN(Boolean.class, Boolean.TYPE),
    STRING(String.class),
    OBJECT(new Class[0]);

    private final Class[] supportedTypes;

    private InternalOperandTypeForCalculations(Class ... supportedTypes) {
        this.supportedTypes = supportedTypes;
    }

    public Class[] getSupportedTypes() {
        return this.supportedTypes;
    }

    public boolean isSupportedType(Class type) {
        if (type == null) {
            return false;
        }
        return InternalOperandTypeForCalculations.getSupportedOperandModeClasses(this).contains(type);
    }

    public static Set<Class> getSupportedOperandModeClasses(InternalOperandTypeForCalculations ... internalOperandTypeForCalculationses) {
        HashSet<Class> set = new HashSet<Class>();
        if (internalOperandTypeForCalculationses != null) {
            for (InternalOperandTypeForCalculations internalOperandTypeForCalculations : internalOperandTypeForCalculationses) {
                set.addAll(Arrays.asList(internalOperandTypeForCalculations.getSupportedTypes()));
            }
        }
        return set;
    }

    public static InternalOperandTypeForCalculations getOperationModeForOperand(Operand operand) {
        if (operand != null) {
            for (InternalOperandTypeForCalculations internalOperandTypeForCalculations : InternalOperandTypeForCalculations.values()) {
                if (!internalOperandTypeForCalculations.isSupportedType(operand.getOperandsJavaType())) continue;
                return internalOperandTypeForCalculations;
            }
        }
        return OBJECT;
    }
}

