/*
 * Decompiled with CFR 0.152.
 */
package de.holisticon.annotationprocessortoolkit.templating.expressions;

import de.holisticon.annotationprocessortoolkit.templating.ModelPathResolver;
import de.holisticon.annotationprocessortoolkit.templating.expressions.Expression;
import de.holisticon.annotationprocessortoolkit.templating.expressions.operands.Operand;
import de.holisticon.annotationprocessortoolkit.templating.expressions.operands.OperandFactory;
import de.holisticon.annotationprocessortoolkit.templating.expressions.operands.OperandType;
import de.holisticon.annotationprocessortoolkit.templating.expressions.operands.OperandTypeSearchResult;
import de.holisticon.annotationprocessortoolkit.templating.expressions.operations.OperationType;
import de.holisticon.annotationprocessortoolkit.templating.expressions.operations.OperationTypeMode;
import de.holisticon.annotationprocessortoolkit.templating.expressions.operations.OperationTypeSearchResult;
import java.util.ArrayList;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ExpressionParser {
    public static Expression parseExpression(String expressionString, Map<String, Object> model) {
        ModelPathResolver.modelMapThreadLocal.set(model);
        return ExpressionParser.parseExpression(expressionString);
    }

    protected static Expression parseExpression(String expressionString) {
        return ExpressionParser.parseExpressionRecursively(expressionString, false).getExpression();
    }

    public static ExpressionParseResult parseExpressionRecursively(String expressionString, boolean usedBrackets) {
        Pattern openingBracePattern = Pattern.compile("[ ]*[(][ ]*");
        Pattern closingBracePattern = Pattern.compile("[ ]*[)][ ]*");
        ArrayList<Operand> operands = new ArrayList<Operand>();
        ArrayList operations = new ArrayList();
        int index = 0;
        boolean closingBraceDetected = false;
        boolean firstOperand = true;
        while (index < expressionString.length()) {
            Matcher closingBracketMatcher;
            if (firstOperand) {
                firstOperand = false;
            } else {
                OperationTypeSearchResult operationTypeSearchResult = ExpressionParser.getOperationType(expressionString, index);
                operations.add(operationTypeSearchResult.getValue());
                index = operationTypeSearchResult.getEndIndex();
            }
            boolean negated = false;
            ArrayList<OperationType> unaryOperationTypesToBeApplied = new ArrayList<OperationType>();
            boolean found = true;
            block1: while (found) {
                found = false;
                for (OperationType operationType : OperationType.getOperationsByOperationTypeMode(OperationTypeMode.UNARY)) {
                    Matcher unaryOperationMatcher = operationType.getOperationPattern().matcher(expressionString);
                    if (!unaryOperationMatcher.find(index) || unaryOperationMatcher.start() != index) continue;
                    index = unaryOperationMatcher.end();
                    unaryOperationTypesToBeApplied.add(operationType);
                    found = true;
                    continue block1;
                }
            }
            Matcher openingBraceMatcher = openingBracePattern.matcher(expressionString);
            if (openingBraceMatcher.find(index) && openingBraceMatcher.start() == index) {
                index = openingBraceMatcher.end();
                ExpressionParseResult subExpressionResult = ExpressionParser.parseExpressionRecursively(expressionString.substring(index), true);
                operands.add(OperandFactory.createOperand(OperandType.EXPRESSION, expressionString.substring(index, expressionString.length() - subExpressionResult.getRestString().length()), unaryOperationTypesToBeApplied.toArray(new OperationType[unaryOperationTypesToBeApplied.size()]), subExpressionResult.getExpression()));
                expressionString = subExpressionResult.getRestString();
                index = 0;
            } else {
                OperandTypeSearchResult operandTypeSearchResult = ExpressionParser.getOperandType(expressionString, index);
                operands.add(OperandFactory.createOperand((OperandType)((Object)operandTypeSearchResult.getValue()), expressionString.substring(index, operandTypeSearchResult.getEndIndex()), unaryOperationTypesToBeApplied.toArray(new OperationType[unaryOperationTypesToBeApplied.size()]), null));
                index = operandTypeSearchResult.getEndIndex();
            }
            if (!usedBrackets || !(closingBracketMatcher = closingBracePattern.matcher(expressionString)).find(index) || closingBracketMatcher.start() != index) continue;
            return new ExpressionParseResult(new Expression(operands.toArray(new Operand[operands.size()]), operations.toArray(new OperationType[operations.size()])), expressionString.substring(closingBracketMatcher.end()));
        }
        if (usedBrackets) {
            throw new IllegalArgumentException("Can't find closing bracket");
        }
        OperationType[] operationsArray = operations.toArray(new OperationType[operations.size()]);
        return new ExpressionParseResult(new Expression(operands.toArray(new Operand[operands.size()]), operationsArray), expressionString.substring(index));
    }

    public static OperationTypeSearchResult getOperationType(String expressionString, int index) {
        for (OperationType operationType : OperationType.getOperationsByOperationTypeMode(OperationTypeMode.BINARY)) {
            Matcher matcher = operationType.getOperationPattern().matcher(expressionString);
            if (!matcher.find(index) || matcher.start() != index) continue;
            return new OperationTypeSearchResult(operationType, matcher.start(), matcher.end());
        }
        throw new IllegalArgumentException("Can't determine operation type for string : " + expressionString.substring(index));
    }

    public static OperandTypeSearchResult getOperandType(String expressionString, int index) {
        for (OperandType operandType : OperandType.getPatternBasedOperandTypes()) {
            Matcher matcher = operandType.getOperandPattern().matcher(expressionString);
            if (!matcher.find(index) || matcher.start() != index) continue;
            return new OperandTypeSearchResult(operandType, matcher.start(), matcher.end());
        }
        throw new IllegalArgumentException("Can't determine operands type for string : " + expressionString.substring(index));
    }

    private static class ExpressionParseResult {
        Expression expression;
        String restString;

        public ExpressionParseResult(Expression expression, String restString) {
            this.expression = expression;
            this.restString = restString;
        }

        public Expression getExpression() {
            return this.expression;
        }

        public String getRestString() {
            return this.restString;
        }
    }
}

