/*
 * Decompiled with CFR 0.152.
 */
package de.hirola.sportslibrary.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.hirola.kintojava.model.KintoObject;
import de.hirola.sportslibrary.DataRepository;
import de.hirola.sportslibrary.PersistentObject;
import de.hirola.sportslibrary.SportsLibraryApplication;
import de.hirola.sportslibrary.SportsLibraryException;
import de.hirola.sportslibrary.model.MovementType;
import de.hirola.sportslibrary.model.RunningPlan;
import de.hirola.sportslibrary.model.RunningPlanEntry;
import de.hirola.sportslibrary.model.RunningUnit;
import de.hirola.sportslibrary.model.TrainingType;
import de.hirola.sportslibrary.util.RunningPlanTemplate;
import de.hirola.sportslibrary.util.RunningPlanTemplateFile;
import de.hirola.sportslibrary.util.RunningPlanTemplateUnit;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TemplateLoader {
    private final DataRepository dataRepository;
    private boolean isRunningOnAndroid;
    private final SportsLibraryApplication application;
    private final List<RunningPlanTemplate> runningPlanTemplatesImportList;
    private final List<RunningPlan> importedRunningPlans;

    public TemplateLoader(@NotNull DataRepository dataRepository) throws SportsLibraryException {
        if (!dataRepository.isOpen()) {
            throw new SportsLibraryException("The local datastore isn't open. Can't import templates.");
        }
        this.dataRepository = dataRepository;
        this.runningPlanTemplatesImportList = new ArrayList<RunningPlanTemplate>();
        this.importedRunningPlans = new ArrayList<RunningPlan>();
        this.application = null;
        try {
            this.isRunningOnAndroid = System.getProperty("java.vm.vendor").equals("The Android Project");
        }
        catch (SecurityException exception) {
            this.isRunningOnAndroid = false;
        }
    }

    public TemplateLoader(@NotNull DataRepository dataRepository, @Nullable SportsLibraryApplication application) throws SportsLibraryException {
        if (!dataRepository.isOpen()) {
            throw new SportsLibraryException("The local datastore isn't open. Can't import templates.");
        }
        this.dataRepository = dataRepository;
        this.application = application;
        this.runningPlanTemplatesImportList = new ArrayList<RunningPlanTemplate>();
        this.importedRunningPlans = new ArrayList<RunningPlan>();
        try {
            this.isRunningOnAndroid = System.getProperty("java.vm.vendor").equals("The Android Project");
        }
        catch (SecurityException exception) {
            this.isRunningOnAndroid = false;
        }
        if (this.isRunningOnAndroid && application == null) {
            throw new SportsLibraryException("The application must be not null.");
        }
    }

    public void loadAllFromJSON() throws SportsLibraryException {
        this.addMovementTypesFromTemplate();
        this.addTrainingTypesFromTemplate();
        this.addRunningPlansFromTemplate();
    }

    public void loadFromJSON(@NotNull Class<? extends KintoObject> typeOf) throws SportsLibraryException {
        if (this.isRunningOnAndroid && this.application == null) {
            throw new SportsLibraryException("For using this method under Android, the application must not be null. Please initialize the template loader with the constructor (DataRepository, SportsLibraryApplication)");
        }
        if (typeOf.equals(MovementType.class)) {
            this.addMovementTypesFromTemplate();
            return;
        }
        if (typeOf.equals(TrainingType.class)) {
            this.addTrainingTypesFromTemplate();
            return;
        }
        if (typeOf.equals(RunningPlan.class)) {
            this.addRunningPlansFromTemplate();
            return;
        }
        throw new SportsLibraryException("Object type in parameter isn' valid.");
    }

    public RunningPlanTemplate loadRunningPlanTemplateFromJSON(@NotNull InputStream jsonInputStream) throws SportsLibraryException {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            return (RunningPlanTemplate)objectMapper.readValue(jsonInputStream, RunningPlanTemplate.class);
        }
        catch (IOException exception) {
            String errorMessage = "Error occurred while parsing json of running plan template: " + exception;
            throw new SportsLibraryException(errorMessage);
        }
    }

    public RunningPlan importRunningPlanFromTemplate(@NotNull RunningPlanTemplate template) throws SportsLibraryException {
        this.runningPlanTemplatesImportList.add(template);
        this.addRunningPlansFromTemplate();
        if (this.importedRunningPlans.size() == 1) {
            return this.importedRunningPlans.get(0);
        }
        throw new SportsLibraryException("More than one template was imported.");
    }

    public void exportRunningPlanToJSON(RunningPlan runningPlan, Path exportDirPath) throws SportsLibraryException {
        try {
            if (runningPlan == null) {
                throw new SportsLibraryException("Can't save a null object.");
            }
            if (exportDirPath == null) {
                throw new SportsLibraryException("The path must not null.");
            }
            File exportDir = exportDirPath.toFile();
            if (!(exportDir.exists() || exportDir.isDirectory() || exportDir.canWrite())) {
                throw new SportsLibraryException("The directory " + exportDirPath + " doesn't exists or isn't a directory or isn't writable.");
            }
            LocalDate localDate = LocalDate.now();
            String exportFileName = runningPlan.getName().toLowerCase(Locale.ROOT) + "+ export-" + localDate.format(DateTimeFormatter.ISO_DATE) + ".json";
            Path exportFilePath = Paths.get(exportDirPath.toString(), exportFileName);
            ObjectMapper ObjectMapper2 = new ObjectMapper();
            ObjectMapper2.writeValue(exportFilePath.toFile(), (Object)runningPlan);
        }
        catch (IOException | SecurityException exception) {
            String errorMessage = "Error occurred while exporting running plans: ".concat(exception.getMessage());
            throw new SportsLibraryException(errorMessage);
        }
    }

    private void addTrainingTypesFromTemplate() throws SportsLibraryException {
        try {
            TrainingType[] trainingTypes;
            ObjectMapper objectMapper = new ObjectMapper();
            if (this.isRunningOnAndroid) {
                InputStream inputStream = this.application.getTrainingTypeTemplates();
                trainingTypes = (TrainingType[])objectMapper.readValue(inputStream, TrainingType[].class);
            } else {
                TrainingType[] jsonResourceFileName = "/json/training-types.json";
                URL url = this.getClass().getResource((String)jsonResourceFileName);
                if (url == null) {
                    throw new SportsLibraryException("Can't finde the resource file " + (String)jsonResourceFileName);
                }
                Path path = Paths.get(url.toURI());
                trainingTypes = (TrainingType[])objectMapper.readValue(path.toFile(), TrainingType[].class);
            }
            if (trainingTypes.length == 0) {
                throw new SportsLibraryException("Could not load training types.");
            }
            try {
                for (TrainingType trainingType : trainingTypes) {
                    this.dataRepository.add(trainingType);
                }
            }
            catch (SportsLibraryException exception) {
                String errorMessage = "Error occurred while saving an TrainingType object: ".concat(exception.getMessage());
                throw new SportsLibraryException(errorMessage);
            }
        }
        catch (IOException | URISyntaxException exception) {
            String errorMessage = "Error occurred while parsing json of running plan templates: " + exception;
            throw new SportsLibraryException(errorMessage);
        }
    }

    private void addMovementTypesFromTemplate() throws SportsLibraryException {
        try {
            MovementType[] movementTypes;
            ObjectMapper objectMapper = new ObjectMapper();
            if (this.isRunningOnAndroid) {
                InputStream inputStream = this.application.getMovementTypeTemplates();
                movementTypes = (MovementType[])objectMapper.readValue(inputStream, MovementType[].class);
            } else {
                MovementType[] jsonResourceFileName = "/json/movement-types.json";
                URL url = this.getClass().getResource((String)jsonResourceFileName);
                if (url == null) {
                    throw new SportsLibraryException("Can't finde the resource file " + (String)jsonResourceFileName);
                }
                Path path = Paths.get(url.toURI());
                movementTypes = (MovementType[])objectMapper.readValue(path.toFile(), MovementType[].class);
            }
            try {
                for (MovementType movementType : movementTypes) {
                    this.dataRepository.add(movementType);
                }
            }
            catch (SportsLibraryException exception) {
                String errorMessage = "Error occurred while saving an MovementType: " + exception.getMessage();
                throw new SportsLibraryException(errorMessage);
            }
        }
        catch (IOException | URISyntaxException exception) {
            String errorMessage = "Error occurred while parsing json of movement types: " + exception;
            throw new SportsLibraryException(errorMessage);
        }
    }

    private void addRunningPlansFromTemplate() throws SportsLibraryException {
        List<? extends PersistentObject> listOfObjects = this.dataRepository.findAll(MovementType.class);
        if (listOfObjects.size() == 0) {
            throw new SportsLibraryException("There are no movement types in local datastore. Try to import movement types first.");
        }
        Class<?> objectClass = ((Object)((Object)listOfObjects.get(0))).getClass();
        if (!objectClass.isInstance(MovementType.class)) {
            throw new SportsLibraryException("The list contains no movement types.");
        }
        List<? extends PersistentObject> movementTypes = listOfObjects;
        this.loadRunningPlanTemplates();
        if (this.runningPlanTemplatesImportList.size() > 0) {
            for (RunningPlanTemplate runningPlanTemplate : this.runningPlanTemplatesImportList) {
                ArrayList<RunningPlanEntry> runningPlanEntries = new ArrayList<RunningPlanEntry>();
                for (RunningPlanTemplateUnit unit : runningPlanTemplate.getTrainingUnits()) {
                    ArrayList<RunningUnit> runningUnits = new ArrayList<RunningUnit>();
                    MovementType movementType = null;
                    int duration = 0;
                    int index = 0;
                    Iterator runningUnitStringsIterator = Arrays.stream(unit.getUnits()).iterator();
                    while (runningUnitStringsIterator.hasNext()) {
                        String runningUnitString = (String)runningUnitStringsIterator.next();
                        if (index % 2 == 0) {
                            try {
                                duration = Integer.parseInt(runningUnitString);
                            }
                            catch (NumberFormatException exception) {
                                duration = 0;
                                exception.printStackTrace();
                            }
                        } else {
                            for (MovementType movementType2 : movementTypes) {
                                if (!movementType2.getKey().equalsIgnoreCase(runningUnitString)) continue;
                                movementType = movementType2;
                            }
                            if (movementType == null) {
                                throw new SportsLibraryException("A required movement type (key) wasn't found in import.");
                            }
                            RunningUnit runningUnit = new RunningUnit(duration, movementType);
                            try {
                                this.dataRepository.add(runningUnit);
                            }
                            catch (SportsLibraryException sportsLibraryException) {
                                String errorMessage = "Error occurred while saving a RunningUnit: ".concat(sportsLibraryException.getMessage());
                                throw new SportsLibraryException(errorMessage);
                            }
                            runningUnits.add(runningUnit);
                        }
                        ++index;
                    }
                    RunningPlanEntry runningPlanEntry = new RunningPlanEntry(unit.getDay(), unit.getWeek(), runningUnits);
                    try {
                        this.dataRepository.add(runningPlanEntry);
                    }
                    catch (SportsLibraryException exception) {
                        String string = "Error occurred while saving a RunningPlanEntry: ".concat(exception.getMessage());
                        throw new SportsLibraryException(string);
                    }
                    runningPlanEntries.add(runningPlanEntry);
                }
                RunningPlan runningPlan = new RunningPlan(runningPlanTemplate.getName(), runningPlanTemplate.getRemarks(), runningPlanTemplate.getOrderNumber(), runningPlanEntries, runningPlanTemplate.isTemplate);
                try {
                    this.dataRepository.add(runningPlan);
                    this.importedRunningPlans.add(runningPlan);
                }
                catch (SportsLibraryException exception) {
                    String errorMessage = "Error occurred while saving an RunningPlan: " + exception.getMessage();
                    throw new SportsLibraryException(errorMessage);
                }
            }
        } else {
            throw new SportsLibraryException("The list of running plan templates was empty. The import failed.");
        }
        this.runningPlanTemplatesImportList.clear();
    }

    private void loadRunningPlanTemplates() throws SportsLibraryException {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            if (this.isRunningOnAndroid) {
                InputStream[] inputStreams = this.application.getRunningPlanTemplates();
                Iterator inputStreamIterator = Arrays.stream(inputStreams).iterator();
                while (inputStreamIterator.hasNext()) {
                    this.runningPlanTemplatesImportList.add((RunningPlanTemplate)objectMapper.readValue((InputStream)inputStreamIterator.next(), RunningPlanTemplate.class));
                }
            } else {
                Object jsonResourceFileName = "/json/index-of-templates.json";
                URL url = this.getClass().getResource((String)jsonResourceFileName);
                if (url == null) {
                    throw new SportsLibraryException("Can't finde the resource file " + (String)jsonResourceFileName);
                }
                Path path = Paths.get(url.toURI());
                List<RunningPlanTemplateFile> runningPlanTemplateFiles = Arrays.asList((RunningPlanTemplateFile[])objectMapper.readValue(path.toFile(), RunningPlanTemplateFile[].class));
                if (runningPlanTemplateFiles.isEmpty()) {
                    throw new SportsLibraryException("There are no running plan templates in index file.");
                }
                for (RunningPlanTemplateFile runningPlanTemplateFile : runningPlanTemplateFiles) {
                    jsonResourceFileName = "/json/" + runningPlanTemplateFile.getFileName() + ".json";
                    url = this.getClass().getResource((String)jsonResourceFileName);
                    if (url == null) {
                        throw new SportsLibraryException("Can't finde the resource file " + (String)jsonResourceFileName);
                    }
                    path = Paths.get(url.toURI());
                    RunningPlanTemplate runningPlanTemplate = (RunningPlanTemplate)objectMapper.readValue(path.toFile(), RunningPlanTemplate.class);
                    this.runningPlanTemplatesImportList.add(runningPlanTemplate);
                }
            }
        }
        catch (IOException | URISyntaxException exception) {
            String errorMessage = "Error occurred while parsing json of running plan templates: " + exception;
            throw new SportsLibraryException(errorMessage);
        }
    }
}

