/*
 * Decompiled with CFR 0.152.
 */
package de.hirola.sportslibrary.util;

import de.hirola.kintojava.KintoLogger;
import org.jetbrains.annotations.Nullable;

public final class Logger {
    private static Logger instance;
    private final KintoLogger kintoLogger;

    public static Logger getInstance(String logFileName) {
        if (instance == null) {
            instance = new Logger(logFileName);
        }
        return instance;
    }

    public void info(String tag, String message, @Nullable Exception exception) {
        this.kintoLogger.log(0, tag, message, exception);
    }

    public void warning(String tag, String message, @Nullable Exception exception) {
        this.kintoLogger.log(1, tag, message, exception);
    }

    public void error(String tag, String message, @Nullable Exception exception) {
        this.kintoLogger.log(2, tag, message, exception);
    }

    public void debug(String tag, String message, @Nullable Exception exception) {
        this.kintoLogger.log(3, tag, message, exception);
    }

    private Logger(String logFileName) {
        this.kintoLogger = KintoLogger.getInstance((String)logFileName);
    }
}

