/*
 * Decompiled with CFR 0.152.
 */
package de.hirola.sportslibrary.model;

import de.hirola.kintojava.model.Persisted;
import de.hirola.sportslibrary.Global;
import de.hirola.sportslibrary.PersistentObject;
import de.hirola.sportslibrary.model.RunningPlan;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;

public class User
extends PersistentObject {
    @Persisted
    private final String userID = UUID.randomUUID().toString().replace("-", "");
    @Persisted
    private String firstName = "";
    @Persisted
    private String lastName = "Athlete";
    @Persisted
    private String emailAddress = "";
    @Persisted
    private LocalDate birthday = LocalDate.now();
    @Persisted
    private int gender = 0;
    @Persisted
    private int trainingLevel = 0;
    @Persisted
    private int maxPulse = 0;
    @Persisted
    private RunningPlan activeRunningPlan = null;

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public String getEmailAddress() {
        return this.emailAddress;
    }

    public void setEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    public LocalDate getBirthday() {
        return this.birthday;
    }

    public void setBirthday(LocalDate birthday) {
        this.birthday = birthday;
    }

    public int getGender() {
        return this.gender;
    }

    public void setGender(int gender) {
        if (Global.TrainingParameter.genderValues.containsKey(gender)) {
            this.gender = gender;
        }
    }

    public int getTrainingLevel() {
        return this.trainingLevel;
    }

    public void setTrainingLevel(int trainingLevel) {
        this.trainingLevel = trainingLevel;
    }

    public int getMaxPulse() {
        return this.maxPulse;
    }

    public void setMaxPulse(int maxPulse) {
        this.maxPulse = maxPulse;
    }

    public RunningPlan getActiveRunningPlan() {
        return this.activeRunningPlan;
    }

    public void setActiveRunningPlan(RunningPlan activeRunningPlan) {
        this.activeRunningPlan = activeRunningPlan;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        User user = (User)((Object)o);
        return this.userID.equals(user.userID) && Objects.equals(this.emailAddress, user.emailAddress);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.userID, this.emailAddress);
    }

    @Override
    public List<String> getIdentityAttributeNames() {
        ArrayList<String> identityAttributeNames = new ArrayList<String>();
        identityAttributeNames.add("userID");
        identityAttributeNames.add("emailAddress");
        return identityAttributeNames;
    }
}

