/*
 * Decompiled with CFR 0.152.
 */
package de.hirola.sportslibrary.model;

import de.hirola.kintojava.model.Persisted;
import de.hirola.sportslibrary.PersistentObject;
import de.hirola.sportslibrary.model.Track;
import de.hirola.sportslibrary.model.TrainingType;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Training
extends PersistentObject {
    @Persisted
    private String name;
    @Persisted
    private String remarks;
    @Persisted
    private TrainingType trainingType;
    @Persisted
    private LocalDate trainingDate;
    @Persisted
    private Track track;
    @Persisted
    private long duration;
    @Persisted
    private double distance;
    @Persisted
    private double altitudeDifference;
    @Persisted
    private double averageSpeed;

    public Training() {
        this.name = "Training";
        this.remarks = "";
        this.distance = -1.0;
        this.altitudeDifference = -1.0;
        this.averageSpeed = -1.0;
    }

    public Training(@NotNull String name, @Nullable String remarks, @Nullable TrainingType trainingType, @NotNull Track track, @Nullable LocalDate trainingDate) {
        this.name = name;
        this.remarks = Objects.requireNonNullElse(remarks, "");
        this.trainingType = Objects.requireNonNullElseGet(trainingType, TrainingType::new);
        this.track = track;
        this.trainingDate = Objects.requireNonNullElseGet(trainingDate, () -> LocalDate.now(ZoneId.systemDefault()));
        this.distance = track.getDistance();
        this.altitudeDifference = track.getAverageSpeed();
        this.averageSpeed = track.getAverageSpeed();
    }

    public Training(@NotNull String name, @Nullable String remarks, @Nullable TrainingType trainingType, @Nullable LocalDate trainingDate, @Nullable Track track, double distance, double averageSpeed, double altitudeDifference) {
        this.name = name;
        this.remarks = Objects.requireNonNullElse(remarks, "");
        this.trainingType = Objects.requireNonNullElseGet(trainingType, TrainingType::new);
        this.track = track;
        this.trainingDate = Objects.requireNonNullElseGet(trainingDate, () -> LocalDate.now(ZoneId.systemDefault()));
        this.distance = distance;
        this.averageSpeed = averageSpeed;
        this.altitudeDifference = altitudeDifference;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getRemarks() {
        return this.remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public TrainingType getTrainingType() {
        return this.trainingType;
    }

    public void setTrainingType(TrainingType trainingType) {
        this.trainingType = trainingType;
    }

    public LocalDate getTrainingDate() {
        return this.trainingDate;
    }

    public void setTrainingDate(LocalDate trainingDate) {
        this.trainingDate = trainingDate;
    }

    @Nullable
    public Track getTrack() {
        return this.track;
    }

    public void setTrack(Track track) {
        this.track = track;
    }

    public long getDuration() {
        return this.duration;
    }

    public void setDuration(int duration) {
        this.duration = duration;
    }

    public double getDistance() {
        return this.distance;
    }

    public void setDistance(double distance) {
        this.distance = distance;
    }

    public double getAltitudeDifference() {
        return this.altitudeDifference;
    }

    public void setAltitudeDifference(double altitudeDifference) {
        this.altitudeDifference = altitudeDifference;
    }

    public double getAverageSpeed() {
        return this.averageSpeed;
    }

    public void setAverageSpeed(double averageSpeed) {
        this.averageSpeed = averageSpeed;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Training training = (Training)((Object)o);
        return this.name.equals(training.name);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.name);
    }

    @Override
    public List<String> getIdentityAttributeNames() {
        ArrayList<String> identityAttributeNames = new ArrayList<String>();
        identityAttributeNames.add("name");
        return identityAttributeNames;
    }
}

