/*
 * Decompiled with CFR 0.152.
 */
package de.hirola.sportslibrary.model;

import de.hirola.kintojava.model.Persisted;
import de.hirola.sportslibrary.PersistentObject;
import de.hirola.sportslibrary.model.LocationData;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Track
extends PersistentObject {
    private Id trackId;
    @Persisted
    private String name = "";
    @Persisted
    private String description = "";
    @Persisted
    private LocalDate importDate = LocalDate.now();
    @Persisted
    private long startTime = -1L;
    @Persisted
    private long stopTime = -1L;
    @Persisted
    private double distance = -1.0;
    @Persisted
    private double averageSpeed = -1.0;
    @Persisted
    private double altitudeDifference = -1.0;
    @Persisted
    private List<LocationData> locations;

    public Track() {
        this.locations = new ArrayList<LocationData>();
    }

    public Track(String name, String description, long startTime) {
        this.name = name;
        this.description = description;
        this.startTime = startTime;
        this.locations = new ArrayList<LocationData>();
    }

    public Track(String name, String description, long startTime, long stopTime, @Nullable List<LocationData> locations) {
        this.name = name;
        this.description = description;
        this.startTime = startTime;
        this.stopTime = stopTime;
        this.locations = Objects.requireNonNullElseGet(locations, ArrayList::new);
    }

    public Track(@NotNull String name, @Nullable String description, @Nullable LocalDate importDate, @NotNull List<LocationData> locations) {
        this.name = name;
        this.description = Objects.requireNonNullElse(description, "");
        this.importDate = Objects.requireNonNullElseGet(importDate, () -> LocalDate.now(ZoneId.systemDefault()));
        this.locations = locations;
    }

    public Track(@NotNull String name, @Nullable String description, @Nullable LocalDate importDate, long startTime, long stopTime, double avg, double distance, @NotNull List<LocationData> locations) {
        this.name = name;
        this.description = Objects.requireNonNullElse(description, "");
        this.importDate = Objects.requireNonNullElseGet(importDate, () -> LocalDate.now(ZoneId.systemDefault()));
        this.startTime = startTime;
        this.stopTime = stopTime;
        this.averageSpeed = avg;
        this.distance = distance;
        this.locations = locations;
    }

    @Nullable
    public Id getTrackId() {
        return this.trackId;
    }

    public void setTrackId(Id trackId) {
        this.trackId = trackId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public long getStopTime() {
        return this.stopTime;
    }

    public void setStopTime(long stopTime) {
        this.stopTime = stopTime;
    }

    public double getDistance() {
        return this.distance;
    }

    public void setDistance(double distance) {
        this.distance = distance;
    }

    public double getAverageSpeed() {
        return this.averageSpeed;
    }

    public void setAverageSpeed(double speed) {
        this.averageSpeed = speed;
    }

    public double getAltitudeDifference() {
        return this.altitudeDifference;
    }

    public void setAltitudeDifference(double altitudeDifference) {
        this.altitudeDifference = altitudeDifference;
    }

    public LocalDate getImportDate() {
        return this.importDate;
    }

    public List<LocationData> getLocations() {
        if (this.locations == null) {
            this.locations = new ArrayList<LocationData>();
        }
        return this.locations;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Track track = (Track)((Object)o);
        return this.name.equals(track.name) && this.description.equals(track.description) && this.startTime == track.startTime && this.stopTime == track.stopTime;
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.name, this.description, this.startTime, this.stopTime);
    }

    @Override
    public List<String> getIdentityAttributeNames() {
        ArrayList<String> identityAttributeNames = new ArrayList<String>();
        identityAttributeNames.add("name");
        return identityAttributeNames;
    }

    public static class Id {
        private final long id;

        public Id(long id) {
            this.id = id;
        }

        public long getId() {
            return this.id;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Id id1 = (Id)o;
            return this.id == id1.id;
        }

        public int hashCode() {
            return Objects.hash(this.id);
        }

        public String toString() {
            return String.valueOf(this.id);
        }
    }
}

