/*
 * Decompiled with CFR 0.152.
 */
package de.hirola.sportslibrary.model;

import de.hirola.kintojava.model.Persisted;
import de.hirola.sportslibrary.PersistentObject;
import de.hirola.sportslibrary.model.RunningUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class RunningPlanEntry
extends PersistentObject {
    @Persisted
    private final int week;
    @Persisted
    private final int day;
    @Persisted
    private final List<RunningUnit> runningUnits;

    public RunningPlanEntry() {
        this.day = 1;
        this.week = 1;
        this.runningUnits = new ArrayList<RunningUnit>();
    }

    public RunningPlanEntry(int day, int week, @NotNull ArrayList<RunningUnit> runningUnits) {
        this.day = day;
        this.week = week;
        this.runningUnits = runningUnits;
    }

    public int getDay() {
        return this.day;
    }

    public int getWeek() {
        return this.week;
    }

    public List<RunningUnit> getRunningUnits() {
        return this.runningUnits;
    }

    public long getDuration() {
        return this.runningUnits.stream().map(RunningUnit::getDuration).reduce(0L, Long::sum);
    }

    public boolean isCompleted() {
        return this.runningUnits.stream().allMatch(RunningUnit::isCompleted);
    }

    public int percentCompleted() {
        int countOfEntries = this.runningUnits.size();
        boolean percent = false;
        int completed = 0;
        if (countOfEntries > 0) {
            for (RunningUnit runningUnit : this.runningUnits) {
                if (!runningUnit.isCompleted()) continue;
                ++completed;
            }
            completed = completed * 100 / countOfEntries;
        }
        return completed;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RunningPlanEntry that = (RunningPlanEntry)((Object)o);
        return this.week == that.week && this.day == that.day;
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.week, this.day);
    }

    @Override
    public List<String> getIdentityAttributeNames() {
        ArrayList<String> identityAttributeNames = new ArrayList<String>();
        identityAttributeNames.add("week");
        identityAttributeNames.add("day");
        return identityAttributeNames;
    }
}

