/*
 * Decompiled with CFR 0.152.
 */
package de.hirola.sportslibrary.model;

import de.hirola.kintojava.model.Persisted;
import de.hirola.sportslibrary.PersistentObject;
import de.hirola.sportslibrary.model.RunningPlanEntry;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class RunningPlan
extends PersistentObject {
    @Persisted
    private String name;
    @Persisted
    private String remarks;
    @Persisted
    private int orderNumber;
    @Persisted
    private LocalDate startDate;
    @Persisted
    private final boolean isTemplate;
    @Persisted
    private List<RunningPlanEntry> entries;

    public RunningPlan() {
        this.name = "";
        this.remarks = "";
        this.orderNumber = 0;
        this.startDate = LocalDate.now();
        this.adjustStartDate();
        this.entries = new ArrayList<RunningPlanEntry>();
        this.isTemplate = false;
    }

    public RunningPlan(String name, String remarks, int orderNumber, ArrayList<RunningPlanEntry> entries, boolean isTemplate) {
        this.name = name;
        this.orderNumber = orderNumber;
        this.remarks = remarks;
        this.entries = entries;
        this.isTemplate = isTemplate;
        this.startDate = LocalDate.now();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getRemarks() {
        return this.remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public int getOrderNumber() {
        return this.orderNumber;
    }

    public void setOrderNumber(int orderNumber) {
        this.orderNumber = orderNumber;
    }

    public LocalDate getStartDate() {
        return this.startDate;
    }

    public void setStartDate(LocalDate startDate) {
        if (!this.isActive()) {
            this.startDate = startDate;
            this.adjustStartDate();
        }
    }

    public List<RunningPlanEntry> getEntries() {
        return this.entries;
    }

    public void addEntry(RunningPlanEntry runningPlanEntry) {
        if (runningPlanEntry == null) {
            return;
        }
        if (this.entries == null) {
            this.entries = new ArrayList<RunningPlanEntry>();
        }
        if (!this.entries.contains((Object)runningPlanEntry)) {
            this.entries.add(runningPlanEntry);
        }
    }

    public boolean isTemplate() {
        return this.isTemplate;
    }

    public int percentCompleted() {
        int countOfEntries = this.entries.size();
        int completed = 0;
        if (countOfEntries > 0) {
            for (RunningPlanEntry entry : this.entries) {
                if (!entry.isCompleted()) continue;
                ++completed;
            }
            completed = completed * 100 / countOfEntries;
        }
        return completed;
    }

    public long getDuration() {
        return this.entries.stream().map(RunningPlanEntry::getDuration).reduce(0L, Long::sum);
    }

    public boolean isActive() {
        return this.startDate != null && this.entries.stream().anyMatch(RunningPlanEntry::isCompleted);
    }

    public boolean isCompleted() {
        return this.entries.stream().allMatch(RunningPlanEntry::isCompleted);
    }

    public List<RunningPlanEntry> runningPlanEntriesForWeek(int forWeek) {
        ArrayList<RunningPlanEntry> runningPlanEntries = new ArrayList<RunningPlanEntry>();
        if (forWeek <= 0 || this.entries.size() == 0) {
            return runningPlanEntries;
        }
        for (RunningPlanEntry entry : this.entries) {
            if (entry.getWeek() != forWeek) continue;
            runningPlanEntries.add(entry);
        }
        return runningPlanEntries;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RunningPlan that = (RunningPlan)((Object)o);
        return this.name.equals(that.name);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.name);
    }

    @Override
    public List<String> getIdentityAttributeNames() {
        ArrayList<String> identityAttributeNames = new ArrayList<String>();
        identityAttributeNames.add("name");
        return identityAttributeNames;
    }

    private void adjustStartDate() {
        DayOfWeek dayOfWeek;
        LocalDate today = LocalDate.now();
        if (this.startDate.isBefore(today)) {
            this.startDate = today;
        }
        if ((dayOfWeek = this.startDate.getDayOfWeek()) != DayOfWeek.MONDAY) {
            long daysToAdd = 8 - dayOfWeek.getValue();
            this.startDate = this.startDate.plusDays(daysToAdd);
        }
    }
}

