/*
 * Decompiled with CFR 0.152.
 */
package de.hirola.sportslibrary.model;

import de.hirola.kintojava.model.Persisted;
import de.hirola.sportslibrary.PersistentObject;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class LocationData
extends PersistentObject {
    @Persisted
    private final long timeStamp;
    @Persisted
    private final String provider;
    @Persisted
    private final double latitude;
    @Persisted
    private final double longitude;
    @Persisted
    private final double altitude;
    @Persisted
    private final double speed;

    public LocationData() {
        this.timeStamp = LocalDateTime.now().toInstant(ZoneOffset.UTC).toEpochMilli();
        this.provider = "https://www.countrycoordinate.com";
        this.latitude = 51.023639;
        this.longitude = 14.213444;
        this.altitude = 0.0;
        this.speed = 0.0;
    }

    public LocationData(double latitude, double longitude) {
        this.timeStamp = LocalDateTime.now().toInstant(ZoneOffset.UTC).toEpochMilli();
        this.provider = "Unknown";
        this.latitude = latitude;
        this.longitude = longitude;
        this.altitude = 0.0;
        this.speed = 0.0;
    }

    public LocationData(long timeStamp, String provider, double latitude, double longitude, double altitude, double speed) {
        this.timeStamp = timeStamp;
        this.provider = provider;
        this.latitude = latitude;
        this.longitude = longitude;
        this.altitude = altitude;
        this.speed = speed;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LocationData that = (LocationData)((Object)o);
        return that.timeStamp == this.timeStamp && that.provider.equals(this.provider) && Double.compare(that.latitude, this.latitude) == 0 && Double.compare(that.longitude, this.longitude) == 0 && Double.compare(that.altitude, this.altitude) == 0 && Double.compare(that.speed, this.speed) == 0;
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.timeStamp, this.provider, this.latitude, this.longitude, this.altitude, this.speed);
    }

    @Override
    public List<String> getIdentityAttributeNames() {
        ArrayList<String> identityAttributeNames = new ArrayList<String>();
        identityAttributeNames.add("latitude");
        identityAttributeNames.add("longitude");
        identityAttributeNames.add("altitude");
        identityAttributeNames.add("speed");
        identityAttributeNames.add("timeStamp");
        return identityAttributeNames;
    }
}

