/*
 * Decompiled with CFR 0.152.
 */
package de.hirola.sportslibrary;

import de.hirola.sportslibrary.DataRepository;
import de.hirola.sportslibrary.DatastoreDelegate;
import de.hirola.sportslibrary.PersistentObject;
import de.hirola.sportslibrary.SportsLibraryApplication;
import de.hirola.sportslibrary.SportsLibraryException;
import de.hirola.sportslibrary.model.User;
import de.hirola.sportslibrary.util.TemplateLoader;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SportsLibrary
implements DatastoreDelegate {
    private static SportsLibrary instance;
    private final DataRepository dataRepository;
    private List<DatastoreDelegate> delegates;
    private final User appUser;

    public SportsLibrary(@NotNull String packageName, @Nullable SportsLibraryApplication application) throws SportsLibraryException {
        List<? extends PersistentObject> users;
        this.dataRepository = new DataRepository(packageName, this);
        if (this.dataRepository.isEmpty()) {
            TemplateLoader templateLoader = new TemplateLoader(this.dataRepository, application);
            templateLoader.loadAllFromJSON();
        }
        if ((users = this.dataRepository.findAll(User.class)).size() > 1) {
            System.out.println("More as one user in App.");
        }
        if (users.isEmpty()) {
            this.appUser = new User();
            this.dataRepository.add(this.appUser);
        } else {
            PersistentObject persistentObject = users.get(0);
            if (persistentObject instanceof User) {
                this.appUser = (User)persistentObject;
            } else {
                this.appUser = new User();
                System.out.println("Couldn't get the user from datastore.");
            }
        }
    }

    public DataRepository getDataRepository() {
        return this.dataRepository;
    }

    public void addDelegate(@NotNull DatastoreDelegate delegate) {
        if (this.delegates == null) {
            this.delegates = new ArrayList<DatastoreDelegate>();
        }
        if (!this.delegates.contains(delegate)) {
            this.delegates.add(delegate);
        }
    }

    public void removeDelegate(@NotNull DatastoreDelegate delegate) {
        this.delegates.remove(delegate);
    }

    @NotNull
    public User getAppUser() {
        return this.appUser;
    }

    @Override
    public void didObjectAdded(PersistentObject persistentObject) {
        if (this.delegates != null) {
            for (DatastoreDelegate delegate : this.delegates) {
                delegate.didObjectAdded(persistentObject);
            }
        }
    }

    @Override
    public void didObjectUpdated(PersistentObject persistentObject) {
        if (this.delegates != null) {
            for (DatastoreDelegate delegate : this.delegates) {
                delegate.didObjectUpdated(persistentObject);
            }
        }
    }

    @Override
    public void didObjectRemoved(PersistentObject persistentObject) {
        if (this.delegates != null) {
            for (DatastoreDelegate delegate : this.delegates) {
                delegate.didObjectRemoved(persistentObject);
            }
        }
    }
}

