/*
 * Decompiled with CFR 0.152.
 */
package de.hirola.sportslibrary;

import de.hirola.kintojava.Kinto;
import de.hirola.kintojava.KintoConfiguration;
import de.hirola.kintojava.KintoException;
import de.hirola.kintojava.model.KintoObject;
import de.hirola.sportslibrary.DatastoreDelegate;
import de.hirola.sportslibrary.PersistentObject;
import de.hirola.sportslibrary.SportsLibraryException;
import de.hirola.sportslibrary.model.LocationData;
import de.hirola.sportslibrary.model.MovementType;
import de.hirola.sportslibrary.model.RunningPlan;
import de.hirola.sportslibrary.model.RunningPlanEntry;
import de.hirola.sportslibrary.model.RunningUnit;
import de.hirola.sportslibrary.model.Track;
import de.hirola.sportslibrary.model.Training;
import de.hirola.sportslibrary.model.TrainingType;
import de.hirola.sportslibrary.model.User;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DataRepository {
    private final Kinto kinto;
    private final DatastoreDelegate delegate;

    public DataRepository(@NotNull String packageName, @Nullable DatastoreDelegate delegate) throws SportsLibraryException {
        this.delegate = delegate;
        ArrayList<Class<RunningPlan>> typeList = new ArrayList<Class<RunningPlan>>();
        typeList.add(User.class);
        typeList.add(LocationData.class);
        typeList.add(Track.class);
        typeList.add(MovementType.class);
        typeList.add(TrainingType.class);
        typeList.add(Training.class);
        typeList.add(RunningUnit.class);
        typeList.add(RunningPlanEntry.class);
        typeList.add(RunningPlan.class);
        try {
            KintoConfiguration configuration = new KintoConfiguration.Builder(packageName).objectTypes(typeList).build();
            this.kinto = new Kinto(configuration);
        }
        catch (KintoException exception) {
            throw new SportsLibraryException(exception.getMessage());
        }
    }

    public boolean isEmpty() throws SportsLibraryException {
        int emptyValueCounter = 0;
        try {
            List runningPlans;
            List trainingTypes;
            List movementTypes = this.kinto.findAll(MovementType.class);
            if (movementTypes.isEmpty()) {
                ++emptyValueCounter;
            }
            if ((trainingTypes = this.kinto.findAll(TrainingType.class)).isEmpty()) {
                ++emptyValueCounter;
            }
            if ((runningPlans = this.kinto.findAll(RunningPlan.class)).isEmpty()) {
                ++emptyValueCounter;
            }
        }
        catch (KintoException exception) {
            throw new SportsLibraryException("The content of the local datastore couldn't determined : " + exception.getMessage());
        }
        return emptyValueCounter == 3;
    }

    public boolean isOpen() {
        return this.kinto.isOpen();
    }

    public void add(PersistentObject object) throws SportsLibraryException {
        try {
            this.kinto.add((KintoObject)object);
            if (this.delegate != null) {
                this.delegate.didObjectAdded(object);
            }
        }
        catch (KintoException exception) {
            throw new SportsLibraryException((Exception)((Object)exception));
        }
    }

    public void update(PersistentObject object) throws SportsLibraryException {
        try {
            this.kinto.update((KintoObject)object);
            if (this.delegate != null) {
                this.delegate.didObjectUpdated(object);
            }
        }
        catch (KintoException exception) {
            throw new SportsLibraryException((Exception)((Object)exception));
        }
    }

    public void remove(PersistentObject object) throws SportsLibraryException {
        try {
            this.kinto.remove((KintoObject)object);
            if (this.delegate != null) {
                this.delegate.didObjectRemoved(object);
            }
        }
        catch (KintoException exception) {
            throw new SportsLibraryException((Exception)((Object)exception));
        }
    }

    public List<? extends PersistentObject> findAll(Class<? extends PersistentObject> fromType) throws SportsLibraryException {
        List persistentObjects = new ArrayList();
        try {
            List kintoObjects = this.kinto.findAll(fromType);
            if (!kintoObjects.isEmpty()) {
                if (!kintoObjects.stream().allMatch(p -> p instanceof PersistentObject)) {
                    throw new SportsLibraryException("All objects from result must be extends PersistentObject.");
                }
                persistentObjects = kintoObjects;
                for (PersistentObject persistentObject : persistentObjects) {
                    LocalDate today;
                    LocalDate startDate;
                    RunningPlan runningPlan;
                    if (!(persistentObject instanceof RunningPlan) || (runningPlan = (RunningPlan)persistentObject).isCompleted() && runningPlan.isActive() || !(startDate = runningPlan.getStartDate()).isBefore(today = LocalDate.now()) && !startDate.isEqual(today)) continue;
                    runningPlan.setStartDate(today);
                    try {
                        this.kinto.update((KintoObject)runningPlan);
                    }
                    catch (KintoException exception) {
                        exception.printStackTrace();
                    }
                }
            }
            return persistentObjects;
        }
        catch (KintoException exception) {
            throw new SportsLibraryException((Exception)((Object)exception));
        }
    }
}

