package de.hirola.sportslibrary.util;

import de.hirola.kintojava.KintoLogger;
import org.jetbrains.annotations.Nullable;

/**
 * Copyright 2021 by Michael Schmidt, Hirola Consulting
 * This software us licensed under the AGPL-3.0 or later.
 *
 * Layer for logging of library. Encapsulated the use of logging tools.
 *
 * @author Michael Schmidt (Hirola)
 * @since 1.1.1
 */
public final class Logger {

    private static Logger instance;
    private final KintoLogger kintoLogger; // using kinto logger

    /**
     * Get an instance of logger.
     *
     * @param logFileName name of the log file
     * @return The logger object for logging.
     */
    public static Logger getInstance(String logFileName) {
        if (instance == null) {
            instance = new Logger(logFileName);
        }
        return instance;
    }

    /**
     * Create an info log entry.
     *
     * @param tag source of log entry
     * @param message log message
     * @param exception log exception
     */
    public void info(String tag, String message, @Nullable Exception exception) {
        kintoLogger.log(KintoLogger.INFO, tag, message, exception);
    }

    /**
     * Create an info log entry.
     *
     * @param tag source of log entry
     * @param message log message
     * @param exception log exception
     */
    public void warning(String tag, String message, @Nullable Exception exception) {
        kintoLogger.log(KintoLogger.WARNING, tag, message, exception);
    }

    /**
     * Create an error log entry.
     *
     * @param tag source of log entry
     * @param message log message
     * @param exception log exception
     */
    public void error(String tag, String message, @Nullable Exception exception) {
        kintoLogger.log(KintoLogger.ERROR, tag, message, exception);
    }

    /**
     * Create an debug log entry.
     *
     * @param tag source of log entry
     * @param message log message
     * @param exception log exception
     */
    public void debug(String tag, String message, @Nullable Exception exception) {
        kintoLogger.log(KintoLogger.DEBUG, tag, message, exception);
    }


    private Logger(String logFileName) {
        kintoLogger = KintoLogger.getInstance(logFileName);
    }
}
