package de.hirola.sportslibrary;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Copyright 2021 by Michael Schmidt, Hirola Consulting
 * This software us licensed under the AGPL-3.0 or later.
 *
 * Global library settings.
 *
 * @author Michael Schmidt (Hirola)
 * @since 1.1.1
 */
public final class Global {

    /**
     * enable / disable debug mode
     */
    public static final boolean APP_DEBUG_MODE = true;

    /**
     * training parameter
     */
    public static final class TrainingParameter {
        public static final Map<Integer, String> genderValues;

        static {
            genderValues = new HashMap<>();
            genderValues.put(0, "gender_undefined");
            genderValues.put(1, "gender_diverse");
            genderValues.put(2, "gender_male");
            genderValues.put(3, "gender_female");
        }

        public static final Map<Integer, String> trainingLevel;

        static {
            trainingLevel = new HashMap<>();
            trainingLevel.put(0, "training_beginner");
            trainingLevel.put(1, "training_amateur");
            trainingLevel.put(2, "training_profi");
        }

        public static final Map<String, String> movementTypes;

        static {
            movementTypes = new HashMap<>();
            movementTypes.put("P", "movement_type_pause");
            movementTypes.put("LG", "movement_type_slowing_going");
            movementTypes.put("ZG", "movement_type_speedy_going");
            movementTypes.put("L", "movement_type_running");
            movementTypes.put("R", "movement_type_sprint");
        }
    }

    /**
     * app parameter
     */
    public static final class AppSettings {

        // App-ID -> Bucket (Kinto) -> Datenbank (SQL)
        public static final String appID = "SportsLibrary";
        // MapBox Public Access Token
        public static final String mapboxAccessToken = "";
        // Nutzung der Cloud-Synchronisation, ermöglicht den Zugriff auf die Daten von verschiedenen Endgeräten aus.
        public static final boolean useSync = true;
        // GPS für Aufzeichnung der Strecke und Ermittlung der Geschwindigkeit nutzen.
        public static final boolean useGPS = true;
    }

    /**
     * validation parameter for locations
     */
    public static final class ValidLocationValues {
        // Minimaler Wert der Latitude.
        public static final double latitudeMinValue = -90.0;
        // Maximaler Wert der Latitude.
        public static final double latitudeMaxValue = 90.0;
        // Minimaler Wert der Longitude.
        public static final double longitudeMinValue = -180.0;
        // Maximaler Wert der Longitude.
        public static final double longitudeMaxValue = 180.0;
    }

    // Programm-Vorgaben (Wertebereiche)
    public static final class Defaults {
        // Beginn der GPS-Aufzeichnung ab Anzahl von Location-Updates. Erhöhung der Genauigkeit.
        public static final int locationUpdatesRecordsBeginsAt = 5;
        // nach wie viel Sekunden soll ein Track gespeichert werden
        public static final int trackSaveInterval = 15;
        // Zeitspanne in Sekunden, um welche die "gemessene" Trainingszeit von der berechneten Trainingszeit
        // nach "unten" abweichen kann.
        public static final int activityTimeDifferenz = 900;
        // Toleranzbereich **X** beim Lauftraining
        // **X** < Messwert < **X**
        public static final double movementTolerance = 2.0;

        // Der Maximal-Puls wird nach der Formel 220 (Männer) bzw. 226 (Frauen) - Alter berechnet.
        // 2 = Frau, 3 = Mann
        public static final Map<Integer, Integer> valuesForCalculateMaxPulse;

        static {
            valuesForCalculateMaxPulse = new HashMap<>();
            valuesForCalculateMaxPulse.put(2, 226);
            valuesForCalculateMaxPulse.put(3, 220);
        }

        // Aktuelles Jahr - falls es über Kalender und Datum nicht ermittelt werden kann.
        public static final int actualYear = 2022;
        // Anzahl an anzuzeigenden Trainingswochen bei Laufplänen, wenn noch kein Startdatum gewählt wurde.
        // Aktuell 3 Monate.
        public static final int numberOfSelectableTrainingStartWeeks = 12;
        // Wochentage, beginnend mit dem Index 1
        public static final List<String> daysOfWeeks;

        static {
            daysOfWeeks = new ArrayList<>();
            daysOfWeeks.add("Die Woche fängt mit der 1 an ...");
            daysOfWeeks.add("Montag");
            daysOfWeeks.add("Dienstag");
            daysOfWeeks.add("Mittwoch");
            daysOfWeeks.add("Donnerstag");
            daysOfWeeks.add("Freitag");
            daysOfWeeks.add("Samstag");
            daysOfWeeks.add("Sonntag");
        }
    }

    /**
     * user settings keys
     */
    public static final class PreferencesKeys {
        // sollen Trainings (Tracks) gespeichert werden?
        // boolean
        public static final String saveTrainings = "save_trainings";
        public static final String userTrainingLevel = "user_training_level";
        public static final String userBirthday = "user_birthday";
        public static final String userMaxPulse = "user_max_pulse";
        public static final String userEmailAddress = "user_email_address";
        public static final String userGender = "user_gender";
        public static final String useLocationData = "use_location_data";
        public static final String useFineLocationData = "use_fine_location_data";
        public static final String useNotifications = "use_notifications";
        public static final String useSync = "use_sync";
        public static final String hideTemplates = "hide_templates";
        public static final String debugMode = "debug_mode";
        public static final String sendDebugLog = "send_debug_log";
    }

    // Vorgaben für Farben und Texte (ohne Lokalisierung)
    public static final class ViewDefaults {
        // Standardfarbe für Bewegungsarten, zur grafischen Darstellung
        public static final String movementTypeDefaultColorString ="green";
        //Tabellen-Header
        public static final List<String> routeCollectionTableHeader;

        static {
            routeCollectionTableHeader = new ArrayList<>();
            routeCollectionTableHeader.add("Name der Route");
            routeCollectionTableHeader.add("importiert am");
            routeCollectionTableHeader.add("Länge");
            routeCollectionTableHeader.add("Höhenmeter");
            routeCollectionTableHeader.add("Anzahl Koordinaten");
        }

        public static final List<String> monthlyBikeTrainingTableHeader;

        static {
            monthlyBikeTrainingTableHeader = new ArrayList<>();
            monthlyBikeTrainingTableHeader.add("Tag");
            monthlyBikeTrainingTableHeader.add("Länge");
            monthlyBikeTrainingTableHeader.add("Dauer");
            monthlyBikeTrainingTableHeader.add("Höhenmeter");
        }

        public static final List<String> yearlyBikeTrainingTableHeader;

        static {
            yearlyBikeTrainingTableHeader = new ArrayList<>();
            yearlyBikeTrainingTableHeader.add("Jahr");
            yearlyBikeTrainingTableHeader.add("Länge");
            yearlyBikeTrainingTableHeader.add("Dauer");
            yearlyBikeTrainingTableHeader.add("Höhenmeter");
        }

        public static final List<String> runningPlanTableHeader;

        static {
            runningPlanTableHeader = new ArrayList<>();
            runningPlanTableHeader.add("");
            runningPlanTableHeader.add("Dauer des Trainings");
            runningPlanTableHeader.add("Übersicht");
        }
    }
}
