package de.hirola.sportslibrary.model;

import de.hirola.kintojava.model.Persisted;
import de.hirola.sportslibrary.PersistentObject;

import java.util.ArrayList;
import java.util.List;

/**
 * Copyright 2021 by Michael Schmidt, Hirola Consulting
 * This software us licensed under the AGPL-3.0 or later.
 *
 * A single training unit as part of a training section within a running plan.
 * The movement types can be adjusted and saved.
 * Example: 20 min run
 *
 * @author Michael Schmidt (Hirola)
 * @since 1.1.1
 * @see  RunningPlanEntry
 *
 */
public class RunningUnit extends PersistentObject {

    @Persisted
    private final long duration; // duration in minutes
    @Persisted
    private MovementType movementType;
    @Persisted
    private boolean isCompleted;

    /**
     * Default constructor for reflection.
     */
    public RunningUnit() {
        super();
        duration = 0;
        movementType = new MovementType();
        isCompleted = false;
    }

    /**
     * Create a running unit of a plan entry.
     *
     * @param duration of the unit
     * @param movementType of the unit
     */
    public RunningUnit(int duration, MovementType movementType) {
        this.duration = duration;
        this.movementType = movementType;
        this.isCompleted = false;
    }

    /**
     * Get the type of movement for the unit.
     *
     * @return Type of movement for the unit
     */
    public MovementType getMovementType() {
        return movementType;
    }

    /**
     * Set the type of movement for the unit.
     *
     * @param movementType type of movement for the unit
     */
    public void setMovementType(MovementType movementType) {
        this.movementType = movementType;
    }

    /**
     * Get a flag to determine if unit is completed.
     *
     * @return  A flag to determine if unit is completed
     */
    public boolean isCompleted() {
        return isCompleted;
    }

    /**
     * Set a flag to determine if unit is completed.
     *
     * @param completed A flag to determine if unit is completed
     */
    public void setCompleted(boolean completed) {
        isCompleted = completed;
    }

    /**
     * Get the duration of the unit.
     *
     * @return The duration of the unit
     */
    public long getDuration() {
        return duration;
    }

    @Override
    public List<String> getIdentityAttributeNames() {
        return new ArrayList<>();
    }
}
