package de.hirola.sportslibrary;

import de.hirola.kintojava.model.KintoObject;

import java.util.List;

/**
 * Copyright 2021 by Michael Schmidt, Hirola Consulting
 * This software us licensed under the AGPL-3.0 or later.
 *
 * A layer to abstract the used data management library.
 * Objects of this type can be managed in the data store.
 *
 * @author Michael Schmidt (Hirola)
 * @since 1.1.1
 */
public abstract class PersistentObject extends KintoObject {
    /**
     * Get a list of all (persistent) attribute names of the object
     *
     * @return A list of all (persistent) attribute names of the object
     */
    public abstract List<String> getIdentityAttributeNames();
}
