/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.lambda;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Spliterator;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.stream.Collector;
import java.util.stream.Stream;
import org.jooq.lambda.Seq;
import org.jooq.lambda.WindowSpecification;
import org.jooq.lambda.tuple.Tuple2;

class SeqUtils {
    SeqUtils() {
    }

    static <T> Seq<T>[] seqs(Stream<T> ... streams) {
        if (streams == null) {
            return null;
        }
        return (Seq[])Seq.of(streams).map(Seq::seq).toArray(Seq[]::new);
    }

    static <T> Seq<T>[] seqs(Iterable<T> ... iterables) {
        if (iterables == null) {
            return null;
        }
        return (Seq[])Seq.of(iterables).map(Seq::seq).toArray(Seq[]::new);
    }

    static <T, U> Seq<U> transform(Stream<T> stream, final DelegatingSpliterator<T, U> delegating) {
        final Spliterator delegate = stream.spliterator();
        return Seq.seq(new Spliterator<U>(){

            @Override
            public boolean tryAdvance(Consumer<? super U> action) {
                return delegating.tryAdvance(delegate, action);
            }

            @Override
            public Spliterator<U> trySplit() {
                return null;
            }

            @Override
            public long estimateSize() {
                return delegate.estimateSize();
            }

            @Override
            public int characteristics() {
                return delegate.characteristics();
            }
        });
    }

    static <T> Map<?, List<Tuple2<T, Long>>> partitions(WindowSpecification<T> window, List<Tuple2<T, Long>> input) {
        return Seq.seq(input).groupBy(window.partition().compose(t -> t.v1), Collector.of(() -> window.order().isPresent() ? new TreeSet<Tuple2>(Comparator.comparing(t -> t.v1, window.order().get()).thenComparing(t -> (Long)t.v2)) : new ArrayList(), (s2, t) -> s2.add(t), (s1, s2) -> {
            s1.addAll(s2);
            return s1;
        }, s2 -> s2 instanceof ArrayList ? (List)s2 : new ArrayList(s2), new Collector.Characteristics[0]));
    }

    static void sneakyThrow(Throwable throwable) {
        SeqUtils.sneakyThrow0(throwable);
    }

    static <E extends Throwable> void sneakyThrow0(Throwable throwable) throws E {
        throw throwable;
    }

    @FunctionalInterface
    static interface DelegatingSpliterator<T, U> {
        public boolean tryAdvance(Spliterator<T> var1, Consumer<? super U> var2);
    }
}

