/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.lambda;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Optional;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.jooq.lambda.Seq;
import org.jooq.lambda.Sum;
import org.jooq.lambda.tuple.Tuple;
import org.jooq.lambda.tuple.Tuple2;

public class Agg {
    public static <T> Collector<T, ?, Long> count() {
        return Collectors.counting();
    }

    public static <T> Collector<T, ?, Long> countDistinct() {
        return Agg.countDistinctBy(t -> t);
    }

    public static <T, U> Collector<T, ?, Long> countDistinctBy(Function<? super T, ? extends U> function) {
        return Collector.of(() -> new HashSet(), (s2, v) -> s2.add(function.apply(v)), (s1, s2) -> {
            s1.addAll(s2);
            return s1;
        }, s2 -> s2.size(), new Collector.Characteristics[0]);
    }

    public static <T> Collector<T, ?, Optional<T>> sum() {
        return Agg.sum(t -> t);
    }

    public static <T, U> Collector<T, ?, Optional<U>> sum(Function<? super T, ? extends U> function) {
        return Collector.of(() -> new Sum[1], (s2, v) -> {
            if (s2[0] == null) {
                s2[0] = Sum.create(function.apply(v));
            } else {
                s2[0].add(function.apply(v));
            }
        }, (s1, s2) -> {
            s1[0].add(s2[0]);
            return s1;
        }, s2 -> s2[0] == null ? Optional.empty() : Optional.of(s2[0].sum()), new Collector.Characteristics[0]);
    }

    public static <T> Collector<T, ?, Optional<T>> avg() {
        return Agg.avg(t -> t);
    }

    public static <T, U> Collector<T, ?, Optional<U>> avg(Function<? super T, ? extends U> function) {
        return Collector.of(() -> new Sum[1], (s2, v) -> {
            if (s2[0] == null) {
                s2[0] = Sum.create(function.apply(v));
            } else {
                s2[0].add(function.apply(v));
            }
        }, (s1, s2) -> {
            s1[0].add(s2[0]);
            return s1;
        }, s2 -> s2[0] == null ? Optional.empty() : Optional.of(s2[0].avg()), new Collector.Characteristics[0]);
    }

    public static <T extends Comparable<? super T>> Collector<T, ?, Optional<T>> min() {
        return Agg.minBy(t -> t, Comparator.naturalOrder());
    }

    public static <T> Collector<T, ?, Optional<T>> min(Comparator<? super T> comparator) {
        return Agg.minBy(t -> t, comparator);
    }

    public static <T, U extends Comparable<? super U>> Collector<T, ?, Optional<U>> min(Function<? super T, ? extends U> function) {
        return Agg.min(function, Comparator.naturalOrder());
    }

    public static <T, U> Collector<T, ?, Optional<U>> min(Function<? super T, ? extends U> function, Comparator<? super U> comparator) {
        return Collectors.collectingAndThen(Agg.minBy(function, comparator), t -> t.map(function));
    }

    public static <T, U extends Comparable<? super U>> Collector<T, ?, Optional<T>> minBy(Function<? super T, ? extends U> function) {
        return Agg.minBy(function, Comparator.naturalOrder());
    }

    public static <T, U> Collector<T, ?, Optional<T>> minBy(Function<? super T, ? extends U> function, Comparator<? super U> comparator) {
        return Agg.maxBy(function, comparator.reversed());
    }

    public static <T extends Comparable<? super T>> Collector<T, ?, Optional<T>> max() {
        return Agg.maxBy(t -> t, Comparator.naturalOrder());
    }

    public static <T> Collector<T, ?, Optional<T>> max(Comparator<? super T> comparator) {
        return Agg.maxBy(t -> t, comparator);
    }

    public static <T, U extends Comparable<? super U>> Collector<T, ?, Optional<U>> max(Function<? super T, ? extends U> function) {
        return Agg.max(function, Comparator.naturalOrder());
    }

    public static <T, U> Collector<T, ?, Optional<U>> max(Function<? super T, ? extends U> function, Comparator<? super U> comparator) {
        return Collectors.collectingAndThen(Agg.maxBy(function, comparator), t -> t.map(function));
    }

    public static <T, U extends Comparable<? super U>> Collector<T, ?, Optional<T>> maxBy(Function<? super T, ? extends U> function) {
        return Agg.maxBy(function, Comparator.naturalOrder());
    }

    public static <T, U> Collector<T, ?, Optional<T>> maxBy(Function<? super T, ? extends U> function, Comparator<? super U> comparator) {
        return Collector.of(() -> new Tuple2[]{Tuple.tuple(null, null)}, (a, t) -> {
            Object u = function.apply(t);
            if (a[0].v2 == null || comparator.compare((Object)a[0].v2, (Object)u) < 0) {
                a[0] = Tuple.tuple(t, u);
            }
        }, (a1, a2) -> comparator.compare((Object)a1[0].v2, (Object)a2[0].v2) < 0 ? a2 : a1, a -> Optional.ofNullable(a[0].v1), new Collector.Characteristics[0]);
    }

    public static Collector<Boolean, ?, Boolean> allMatch() {
        return Agg.allMatch(t -> t);
    }

    public static <T> Collector<T, ?, Boolean> allMatch(Predicate<? super T> predicate) {
        return Collector.of(() -> new Boolean[1], (a, t) -> {
            a[0] = a[0] == null ? Boolean.valueOf(predicate.test(t)) : Boolean.valueOf(a[0] != false && predicate.test(t));
        }, (a1, a2) -> {
            a1[0] = a1[0] != false && a2[0] != false;
            return a1;
        }, a -> a[0] == null || a[0] != false, new Collector.Characteristics[0]);
    }

    public static Collector<Boolean, ?, Boolean> anyMatch() {
        return Agg.anyMatch(t -> t);
    }

    public static <T> Collector<T, ?, Boolean> anyMatch(Predicate<? super T> predicate) {
        return Collectors.collectingAndThen(Agg.noneMatch(predicate), t -> t == false);
    }

    public static Collector<Boolean, ?, Boolean> noneMatch() {
        return Agg.noneMatch(t -> t);
    }

    public static <T> Collector<T, ?, Boolean> noneMatch(Predicate<? super T> predicate) {
        return Agg.allMatch(predicate.negate());
    }

    public static <T> Collector<T, ?, Optional<T>> mode() {
        return Collector.of(() -> new LinkedHashMap(), (m3, v) -> m3.compute(v, (k1, v1) -> v1 == null ? 1L : v1 + 1L), (m1, m22) -> {
            m1.putAll(m22);
            return m1;
        }, m3 -> Seq.seq(m3).maxBy(t -> (Long)t.v2).map(t -> t.v1), new Collector.Characteristics[0]);
    }

    public static <T extends Comparable<? super T>> Collector<T, ?, Optional<Long>> rank(T value) {
        return Agg.rankBy(value, t -> t, Comparator.naturalOrder());
    }

    public static <T> Collector<T, ?, Optional<Long>> rank(T value, Comparator<? super T> comparator) {
        return Agg.rankBy(value, t -> t, comparator);
    }

    public static <T, U extends Comparable<? super U>> Collector<T, ?, Optional<Long>> rankBy(U value, Function<? super T, ? extends U> function) {
        return Agg.rankBy(value, function, Comparator.naturalOrder());
    }

    public static <T, U> Collector<T, ?, Optional<Long>> rankBy(U value, Function<? super T, ? extends U> function, Comparator<? super U> comparator) {
        return Collector.of(() -> new ArrayList(), (l, v) -> l.add(function.apply(v)), (l1, l2) -> {
            l1.addAll(l2);
            return l1;
        }, l -> {
            int size = l.size();
            if (size == 0) {
                return Optional.empty();
            }
            l.sort(comparator);
            for (int i = 0; i < size; ++i) {
                if (comparator.compare((Object)value, (Object)l.get(i)) > 0) continue;
                return Optional.of(Long.valueOf(i));
            }
            return Optional.of(Long.valueOf(size));
        }, new Collector.Characteristics[0]);
    }

    public static <T extends Comparable<? super T>> Collector<T, ?, Optional<Long>> denseRank(T value) {
        return Agg.denseRankBy(value, t -> t, Comparator.naturalOrder());
    }

    public static <T> Collector<T, ?, Optional<Long>> denseRank(T value, Comparator<? super T> comparator) {
        return Agg.denseRankBy(value, t -> t, comparator);
    }

    public static <T, U extends Comparable<? super U>> Collector<T, ?, Optional<Long>> denseRankBy(U value, Function<? super T, ? extends U> function) {
        return Agg.denseRankBy(value, function, Comparator.naturalOrder());
    }

    public static <T, U> Collector<T, ?, Optional<Long>> denseRankBy(U value, Function<? super T, ? extends U> function, Comparator<? super U> comparator) {
        return Collector.of(() -> new TreeSet(comparator), (l, v) -> l.add(function.apply(v)), (l1, l2) -> {
            l1.addAll(l2);
            return l1;
        }, l -> {
            int size = l.size();
            if (size == 0) {
                return Optional.empty();
            }
            int i = -1;
            Iterator it = l.iterator();
            while (it.hasNext() && i++ < l.size()) {
                if (comparator.compare((Object)value, (Object)it.next()) > 0) continue;
                return Optional.of(Long.valueOf(i));
            }
            return Optional.of(Long.valueOf(size));
        }, new Collector.Characteristics[0]);
    }

    public static <T extends Comparable<? super T>> Collector<T, ?, Optional<Double>> percentRank(T value) {
        return Agg.percentRankBy(value, t -> t, Comparator.naturalOrder());
    }

    public static <T> Collector<T, ?, Optional<Double>> percentRank(T value, Comparator<? super T> comparator) {
        return Agg.percentRankBy(value, t -> t, comparator);
    }

    public static <T, U extends Comparable<? super U>> Collector<T, ?, Optional<Double>> percentRankBy(U value, Function<? super T, ? extends U> function) {
        return Agg.percentRankBy(value, function, Comparator.naturalOrder());
    }

    public static <T, U> Collector<T, ?, Optional<Double>> percentRankBy(U value, Function<? super T, ? extends U> function, Comparator<? super U> comparator) {
        return Collector.of(() -> new ArrayList(), (l, v) -> l.add(function.apply(v)), (l1, l2) -> {
            l1.addAll(l2);
            return l1;
        }, l -> {
            int size = l.size();
            if (size == 0) {
                return Optional.empty();
            }
            l.sort(comparator);
            for (int i = 0; i < size; ++i) {
                if (comparator.compare((Object)value, (Object)l.get(i)) > 0) continue;
                return Optional.of((double)i / (double)size);
            }
            return Optional.of(1.0);
        }, new Collector.Characteristics[0]);
    }

    public static <T extends Comparable<? super T>> Collector<T, ?, Optional<T>> median() {
        return Agg.percentile(0.5);
    }

    public static <T> Collector<T, ?, Optional<T>> median(Comparator<? super T> comparator) {
        return Agg.percentile(0.5, comparator);
    }

    public static <T, U extends Comparable<? super U>> Collector<T, ?, Optional<U>> median(Function<? super T, ? extends U> function) {
        return Agg.percentile(0.5, function);
    }

    public static <T, U> Collector<T, ?, Optional<U>> median(Function<? super T, ? extends U> function, Comparator<? super U> comparator) {
        return Agg.percentile(0.5, function, comparator);
    }

    public static <T, U extends Comparable<? super U>> Collector<T, ?, Optional<T>> medianBy(Function<? super T, ? extends U> function) {
        return Agg.percentileBy(0.5, function, Comparator.naturalOrder());
    }

    public static <T, U> Collector<T, ?, Optional<T>> medianBy(Function<? super T, ? extends U> function, Comparator<? super U> comparator) {
        return Agg.percentileBy(0.5, function, comparator);
    }

    public static <T extends Comparable<? super T>> Collector<T, ?, Optional<T>> percentile(double percentile) {
        return Agg.percentile(percentile, t -> t, Comparator.naturalOrder());
    }

    public static <T> Collector<T, ?, Optional<T>> percentile(double percentile, Comparator<? super T> comparator) {
        return Agg.percentile(percentile, t -> t, comparator);
    }

    public static <T, U extends Comparable<? super U>> Collector<T, ?, Optional<U>> percentile(double percentile, Function<? super T, ? extends U> function) {
        return Agg.percentile(percentile, function, Comparator.naturalOrder());
    }

    public static <T, U> Collector<T, ?, Optional<U>> percentile(double percentile, Function<? super T, ? extends U> function, Comparator<? super U> comparator) {
        return Collectors.collectingAndThen(Agg.percentileBy(percentile, function, comparator), t -> t.map(function));
    }

    public static <T, U extends Comparable<? super U>> Collector<T, ?, Optional<T>> percentileBy(double percentile, Function<? super T, ? extends U> function) {
        return Agg.percentileBy(percentile, function, Comparator.naturalOrder());
    }

    public static <T, U> Collector<T, ?, Optional<T>> percentileBy(double percentile, Function<? super T, ? extends U> function, Comparator<? super U> comparator) {
        if (percentile < 0.0 || percentile > 1.0) {
            throw new IllegalArgumentException("Percentile must be between 0.0 and 1.0");
        }
        return Collector.of(() -> new ArrayList(), (l, v) -> l.add(Tuple.tuple(v, function.apply(v))), (l1, l2) -> {
            l1.addAll(l2);
            return l1;
        }, l -> {
            int size = l.size();
            if (size == 0) {
                return Optional.empty();
            }
            if (size == 1) {
                return Optional.of(((Tuple2)l.get((int)0)).v1);
            }
            l.sort(Comparator.comparing(t -> t.v2, comparator));
            if (percentile == 0.0) {
                return Optional.of(((Tuple2)l.get((int)0)).v1);
            }
            if (percentile == 1.0) {
                return Optional.of(((Tuple2)l.get((int)(size - 1))).v1);
            }
            return Optional.of(((Tuple2)l.get((int)((int)(-Math.round((double)(-((double)size * percentile + 0.5)))) - 1))).v1);
        }, new Collector.Characteristics[0]);
    }
}

