/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.functions.ips;

import com.google.common.collect.ImmutableList;
import java.net.UnknownHostException;
import org.graylog.plugins.pipelineprocessor.EvaluationContext;
import org.graylog.plugins.pipelineprocessor.ast.functions.AbstractFunction;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionArgs;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionDescriptor;
import org.graylog.plugins.pipelineprocessor.ast.functions.ParameterDescriptor;
import org.graylog.plugins.pipelineprocessor.functions.ips.IpAddress;
import org.graylog2.utilities.IpSubnet;

public class CidrMatch
extends AbstractFunction<Boolean> {
    public static final String NAME = "cidr_match";
    public static final String IP = "ip";
    private final ParameterDescriptor<String, IpSubnet> cidrParam = ParameterDescriptor.string("cidr", IpSubnet.class).transform(cidrString -> {
        try {
            return new IpSubnet(cidrString);
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException(e);
        }
    }).description("The CIDR subnet mask").build();
    private final ParameterDescriptor<IpAddress, IpAddress> ipParam = ParameterDescriptor.type("ip", IpAddress.class).description("The parsed IP address to match against the CIDR mask").build();

    @Override
    public Boolean evaluate(FunctionArgs args, EvaluationContext context) {
        IpSubnet cidr = this.cidrParam.required(args, context);
        IpAddress ipAddress = this.ipParam.required(args, context);
        if (cidr == null || ipAddress == null) {
            return null;
        }
        return cidr.contains(ipAddress.inetAddress());
    }

    @Override
    public FunctionDescriptor<Boolean> descriptor() {
        return FunctionDescriptor.builder().name(NAME).returnType(Boolean.class).params((ImmutableList<ParameterDescriptor>)ImmutableList.of(this.cidrParam, this.ipParam)).description("Checks if an IP address matches a CIDR subnet mask").build();
    }
}

