/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.ast.functions;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import javax.annotation.Nullable;
import org.graylog.plugins.pipelineprocessor.ast.functions.AutoValue_FunctionDescriptor;
import org.graylog.plugins.pipelineprocessor.ast.functions.ParameterDescriptor;

@JsonAutoDetect
@AutoValue
public abstract class FunctionDescriptor<T> {
    @JsonProperty
    public abstract String name();

    @JsonProperty
    public abstract boolean pure();

    @JsonProperty
    public abstract Class<? extends T> returnType();

    @JsonProperty
    public abstract ImmutableList<ParameterDescriptor> params();

    @JsonIgnore
    public abstract ImmutableMap<String, ParameterDescriptor> paramMap();

    @JsonIgnore
    public ParameterDescriptor param(String name) {
        return (ParameterDescriptor)this.paramMap().get((Object)name);
    }

    @JsonProperty
    @Nullable
    public abstract String description();

    public static <T> Builder<T> builder() {
        return new AutoValue_FunctionDescriptor.Builder().pure(false);
    }

    public static abstract class Builder<T> {
        abstract FunctionDescriptor<T> autoBuild();

        public FunctionDescriptor<T> build() {
            return this.paramMap((ImmutableMap<String, ParameterDescriptor>)Maps.uniqueIndex(this.params(), ParameterDescriptor::name)).autoBuild();
        }

        public abstract Builder<T> name(String var1);

        public abstract Builder<T> pure(boolean var1);

        public abstract Builder<T> returnType(Class<? extends T> var1);

        public Builder<T> params(ParameterDescriptor ... params) {
            return this.params((ImmutableList<ParameterDescriptor>)ImmutableList.builder().add((Object[])params).build());
        }

        public abstract Builder<T> params(ImmutableList<ParameterDescriptor> var1);

        public abstract Builder<T> paramMap(ImmutableMap<String, ParameterDescriptor> var1);

        public abstract ImmutableList<ParameterDescriptor> params();

        public abstract Builder<T> description(@Nullable String var1);
    }
}

