/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.rest;

import com.google.common.collect.Sets;
import com.google.common.eventbus.EventBus;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.graylog.plugins.pipelineprocessor.db.PipelineService;
import org.graylog.plugins.pipelineprocessor.db.PipelineStreamConnectionsService;
import org.graylog.plugins.pipelineprocessor.events.PipelineConnectionsChangedEvent;
import org.graylog.plugins.pipelineprocessor.rest.PipelineConnections;
import org.graylog.plugins.pipelineprocessor.rest.PipelineReverseConnections;
import org.graylog2.audit.jersey.AuditEvent;
import org.graylog2.database.NotFoundException;
import org.graylog2.events.ClusterEventBus;
import org.graylog2.plugin.rest.PluginRestResource;
import org.graylog2.shared.rest.resources.RestResource;
import org.graylog2.streams.StreamService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Api(value="Pipelines/Connections", description="Stream connections of processing pipelines")
@Path(value="/system/pipelines/connections")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@RequiresAuthentication
public class PipelineConnectionsResource
extends RestResource
implements PluginRestResource {
    private static final Logger LOG = LoggerFactory.getLogger(PipelineConnectionsResource.class);
    private final PipelineStreamConnectionsService connectionsService;
    private final PipelineService pipelineService;
    private final StreamService streamService;
    private final EventBus clusterBus;

    @Inject
    public PipelineConnectionsResource(PipelineStreamConnectionsService connectionsService, PipelineService pipelineService, StreamService streamService, ClusterEventBus clusterBus) {
        this.connectionsService = connectionsService;
        this.pipelineService = pipelineService;
        this.streamService = streamService;
        this.clusterBus = clusterBus;
    }

    @ApiOperation(value="Connect processing pipelines to a stream", notes="")
    @POST
    @Path(value="/to_stream")
    @RequiresPermissions(value={"pipeline_connection:edit"})
    @AuditEvent(type="pipeline_processor:pipeline_connection:update")
    public PipelineConnections connectPipelines(@ApiParam(name="Json body", required=true) @NotNull PipelineConnections connection) throws NotFoundException {
        String streamId = connection.streamId();
        this.checkPermission("streams:read", streamId);
        this.streamService.load(streamId);
        for (String s2 : connection.pipelineIds()) {
            this.checkPermission("pipeline:read", s2);
            this.pipelineService.load(s2);
        }
        return this.savePipelineConnections(connection);
    }

    @ApiOperation(value="Connect streams to a processing pipeline", notes="")
    @POST
    @Path(value="/to_pipeline")
    @RequiresPermissions(value={"pipeline_connection:edit"})
    @AuditEvent(type="pipeline_processor:pipeline_connection:update")
    public Set<PipelineConnections> connectStreams(@ApiParam(name="Json body", required=true) @NotNull PipelineReverseConnections connection) throws NotFoundException {
        String pipelineId = connection.pipelineId();
        HashSet updatedConnections = Sets.newHashSet();
        this.checkPermission("pipeline:read", pipelineId);
        this.pipelineService.load(pipelineId);
        Set pipelineConnections = this.connectionsService.loadAll().stream().filter(p -> p.pipelineIds().contains(pipelineId)).collect(Collectors.toSet());
        for (PipelineConnections pipelineConnection : pipelineConnections) {
            if (connection.streamIds().contains(pipelineConnection.streamId())) continue;
            Set<String> pipelines = pipelineConnection.pipelineIds();
            pipelines.remove(connection.pipelineId());
            pipelineConnection.toBuilder().pipelineIds(pipelines).build();
            updatedConnections.add(pipelineConnection);
            this.savePipelineConnections(pipelineConnection);
            LOG.debug("Deleted stream {} connection with pipeline {}", (Object)pipelineConnection.streamId(), (Object)pipelineId);
        }
        for (String streamId : connection.streamIds()) {
            PipelineConnections updatedConnection;
            this.checkPermission("streams:read", streamId);
            this.streamService.load(streamId);
            try {
                updatedConnection = this.connectionsService.load(streamId);
            }
            catch (NotFoundException e) {
                updatedConnection = PipelineConnections.create(null, streamId, Sets.newHashSet());
            }
            Set<String> pipelines = updatedConnection.pipelineIds();
            pipelines.add(pipelineId);
            updatedConnection.toBuilder().pipelineIds(pipelines).build();
            updatedConnections.add(updatedConnection);
            this.savePipelineConnections(updatedConnection);
            LOG.debug("Added stream {} connection with pipeline {}", (Object)streamId, (Object)pipelineId);
        }
        return updatedConnections;
    }

    @ApiOperation(value="Get pipeline connections for the given stream")
    @GET
    @Path(value="/{streamId}")
    @RequiresPermissions(value={"pipeline_connection:read"})
    public PipelineConnections getPipelinesForStream(@ApiParam(name="streamId") @PathParam(value="streamId") String streamId) throws NotFoundException {
        this.checkPermission("streams:read", streamId);
        PipelineConnections connections = this.connectionsService.load(streamId);
        return PipelineConnections.create(connections.id(), connections.streamId(), connections.pipelineIds().stream().filter(id -> this.isPermitted("pipeline:read", (String)id)).collect(Collectors.toSet()));
    }

    @ApiOperation(value="Get all pipeline connections")
    @GET
    @RequiresPermissions(value={"pipeline_connection:read"})
    public Set<PipelineConnections> getAll() throws NotFoundException {
        Set<PipelineConnections> pipelineConnections = this.connectionsService.loadAll();
        HashSet filteredConnections = Sets.newHashSetWithExpectedSize((int)pipelineConnections.size());
        for (PipelineConnections pc : pipelineConnections) {
            if (!this.isPermitted("streams:read", pc.streamId())) continue;
            filteredConnections.add(PipelineConnections.create(pc.id(), pc.streamId(), pc.pipelineIds().stream().filter(id -> this.isPermitted("pipeline:read", (String)id)).collect(Collectors.toSet())));
        }
        return filteredConnections;
    }

    private PipelineConnections savePipelineConnections(PipelineConnections connection) {
        PipelineConnections save = this.connectionsService.save(connection);
        this.clusterBus.post((Object)PipelineConnectionsChangedEvent.create(save.streamId(), save.pipelineIds()));
        return save;
    }
}

